/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.accurev;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.plugin.scm.accurev.AccurevRepository;
import com.pmease.quickbuild.plugin.scm.accurev.Stream;
import com.pmease.quickbuild.plugin.scm.accurev.Workspace;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

public class AccurevProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private AccurevRepository repository;
    private String workspaceName;
    private String userName;
    private String password;
    private String promoteCondition = "build.successful";
    private String promoteComment;

    @Editable(order=100, name="Local Workspace", description="Specify <b>logical name</b> of workspace at user's desktop. Active changes in this workspace will be collected and send to build grid to run a proof build.<p><b>Note:</b> You should not specify full name of the workspace here. For instance, if full name of your local workspace is <i>bugfix_robin</i>, you should only specify <i>bugfix</i> here. QuickBuild will concatenate this logical name with user name below to get the full name.")
    @NotEmpty
    @Scriptable
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    @Editable(order=200, description="Specify associated user name of above local workspace.")
    @NotEmpty
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=300, description="Optionally specify password of above user.")
    @Password
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=400, description="Specify the condition to promote active change. If this condition is satisfied, active change in the workspace specified above will be promoted after the build finishes.")
    @Script
    @Expressions(value={"promote only when build is successful", "build.successful", "always promote", "true", "do not promote", "false"})
    @NotEmpty
    public String getPromoteCondition() {
        return this.promoteCondition;
    }

    public void setPromoteCondition(String promoteCondition) {
        this.promoteCondition = promoteCondition;
    }

    @Editable(order=500, description="Specify the comment when promote the active change. This property only takes effect if the promote condition specified above is satisfied.")
    @Multiline
    @Scriptable
    public String getPromoteComment() {
        return this.promoteComment;
    }

    public void setPromoteComment(String promoteComment) {
        this.promoteComment = promoteComment;
    }

    public AccurevProofBuildSupport(AccurevRepository repository) {
        this.repository = repository;
    }

    private String getWorkspaceFullName() {
        return this.getWorkspaceName() + "_" + this.getUserName();
    }

    private Workspace getWorkspace(Environment authEnv) {
        Workspace workspace = this.repository.getWorkspace(authEnv, this.getWorkspaceFullName());
        if (workspace == null) {
            throw new QuickbuildException("Unable to find workspace '" + this.getWorkspaceFullName() + "'.");
        }
        if (!StringUtils.substringBefore((String)workspace.getHostName(), (String)".").equalsIgnoreCase(StringUtils.substringBefore((String)Grid.instance.getLocalNode().getHostName(), (String)"."))) {
            throw new QuickbuildException("Host name of workspace '" + this.getWorkspaceFullName() + "' is " + "different from host name of the user agent.");
        }
        return workspace;
    }

    private Stream getWorkspaceStream(Environment authEnv) {
        Stream stream = this.repository.getStreamByName(authEnv, this.getWorkspaceFullName());
        if (stream == null) {
            throw new QuickbuildException("Unable to find workspace stream '" + this.getWorkspaceFullName() + "'.");
        }
        return stream;
    }

    private String normalizePath(String path) {
        path = StringUtils.stripStart((String)path, (String)"./\\");
        path = StringUtils.stripEnd((String)path, (String)"./\\");
        path = path.replace('\\', '/');
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChange getLocalChange(File changeStoreDir) {
        LocalChange localChange = new LocalChange();
        File authDir = this.repository.createAuthDir(this.getUserName(), this.getPassword());
        try {
            Environment authEnv = this.repository.createAuthEnv(authDir, this.getUserName(), this.getPassword());
            Workspace workspace = this.getWorkspace(authEnv);
            File workspaceRoot = new File(workspace.getLocation());
            Commandline cmd = this.repository.buildAccurevCmd("update");
            cmd.execute(workspaceRoot, authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            cmd = this.repository.buildAccurevCmd("stat");
            cmd.addArgLine("-o -s");
            cmd.addArgValue(this.getWorkspaceFullName());
            final AtomicBoolean overlap = new AtomicBoolean(false);
            cmd.execute(workspaceRoot, authEnv, (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (line.contains("overlap")) {
                        overlap.set(true);
                    } else {
                        Context.getLogger().debug(line);
                    }
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            if (overlap.get()) {
                throw new QuickbuildException("There are overlap files, please merge them first.");
            }
            Stream workspaceStream = this.getWorkspaceStream(authEnv);
            cmd = this.repository.buildAccurevCmd("diff");
            cmd.addArgLine("-a -i -fx -v").addArgValue(workspaceStream.getBackStreamName()).addArgValue("-V").addArgValue(this.getWorkspaceFullName());
            Document doc = this.repository.buildResponseDoc(cmd, workspaceRoot, authEnv, Sets.newHashSet((Object[])new Integer[]{0, 1}));
            Validate.notNull((Object)doc);
            block3: for (Element element : doc.getRootElement().elements()) {
                for (Element change : element.elements()) {
                    File file;
                    Element stream2;
                    String path;
                    String action = change.attributeValue("What");
                    if (action.equals("defuncted")) {
                        Element stream1 = change.element("Stream1");
                        Preconditions.checkNotNull((Object)stream1);
                        path = stream1.attributeValue("Name");
                        localChange.getDeletePaths().add(this.normalizePath(path));
                        continue block3;
                    }
                    if (action.equals("moved")) {
                        stream2 = change.element("Stream2");
                        Preconditions.checkNotNull((Object)stream2);
                        path = this.normalizePath(stream2.attributeValue("Name"));
                        file = new File(workspaceRoot, path);
                        if (file.isDirectory()) {
                            for (File child : FileUtils.listFiles((File)file, (String)"**")) {
                                if (!child.isFile()) continue;
                                String relativePath = FileUtils.getRelativePath((String)child.getAbsolutePath(), (String)workspaceRoot.getAbsolutePath());
                                relativePath = StringUtils.stripStart((String)relativePath, (String)"/");
                                localChange.getAddPaths().add(relativePath);
                                FileUtils.copyFile((File)child, (File)new File(changeStoreDir, relativePath));
                            }
                        } else {
                            localChange.getAddPaths().add(path);
                            FileUtils.copyFile((File)file, (File)new File(changeStoreDir, path));
                        }
                        localChange.getDeletePaths().add(this.normalizePath(path));
                        Element stream1 = change.element("Stream1");
                        Preconditions.checkNotNull((Object)stream1);
                        path = stream1.attributeValue("Name");
                        localChange.getDeletePaths().add(this.normalizePath(path));
                        continue block3;
                    }
                    if (action.equals("version")) {
                        stream2 = change.element("Stream2");
                        Preconditions.checkNotNull((Object)stream2);
                        path = this.normalizePath(stream2.attributeValue("Name"));
                        file = new File(workspaceRoot, path);
                        if (!file.isFile()) continue block3;
                        FileUtils.copyFile((File)file, (File)new File(changeStoreDir, path));
                        localChange.getModifyPaths().add(path);
                        continue block3;
                    }
                    if (!action.equals("created")) continue;
                    stream2 = change.element("Stream2");
                    Preconditions.checkNotNull((Object)stream2);
                    path = this.normalizePath(stream2.attributeValue("Name"));
                    file = new File(workspaceRoot, path);
                    if (!file.isFile()) continue block3;
                    FileUtils.copyFile((File)file, (File)new File(changeStoreDir, path));
                    localChange.getAddPaths().add(path);
                    continue block3;
                }
            }
        }
        finally {
            this.repository.removeAuthDir(authDir, this.getUserName());
        }
        return localChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        Boolean isPromote = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getPromoteCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isPromote.booleanValue()) {
            File authDir = this.repository.createAuthDir(this.getUserName(), this.getPassword());
            try {
                Environment authEnv = this.repository.createAuthEnv(authDir, this.getUserName(), this.getPassword());
                Workspace workspace = this.getWorkspace(authEnv);
                File workspaceRoot = new File(workspace.getLocation());
                Commandline cmd = this.repository.buildAccurevCmd("promote");
                cmd.addArgValue("-d");
                if (this.getPromoteComment() != null) {
                    cmd.addArgValue("-c").addArgValue(this.getPromoteComment());
                }
                cmd.execute(workspaceRoot, authEnv, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
            finally {
                this.repository.removeAuthDir(authDir, this.getUserName());
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return new File(this.repository.getLocationDir(), repositoryPath);
    }
}

