/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.svn;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.svn.ExternalInfo;
import com.pmease.quickbuild.plugin.scm.svn.SvnRepository;
import com.pmease.quickbuild.plugin.scm.svn.SvnRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SvnSourceViewSupport
extends SourceViewSupport<SvnRevision> {
    public SvnSourceViewSupport(SvnRepository repository) {
        super((Repository)repository);
    }

    public SvnRepository getRepository() {
        return (SvnRepository)super.getRepository();
    }

    public String mapToExternalAware(String repositoryPath) {
        String fileUrl = null;
        if (this.getRepository().getRuntime().getCustomData() != null) {
            List externals = (List)this.getRepository().getRuntime().getCustomData();
            String rootPath = ((String)this.getRepository().getNormalizedUrls().getSecond()).substring(((String)this.getRepository().getNormalizedUrls().getFirst()).length());
            String relativePath = repositoryPath.substring(rootPath.length());
            String relativeToExternal = null;
            for (ExternalInfo external : externals) {
                String temp = FileUtils.getRelativePath((String)relativePath, (String)external.getCheckoutPath());
                if (temp == null || relativeToExternal != null && temp.length() >= relativeToExternal.length()) continue;
                relativeToExternal = temp;
                fileUrl = external.getUrl() + relativeToExternal;
            }
        }
        if (fileUrl == null) {
            fileUrl = (String)this.getRepository().getNormalizedUrls().getFirst() + repositoryPath;
        }
        return fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(String repositoryPath, SvnRevision revision) {
        String fileUrl = null;
        SvnRevision externalRevision = null;
        if (this.getRepository().getRuntime().getCustomData() != null) {
            List externals = (List)this.getRepository().getRuntime().getCustomData();
            String rootPath = ((String)this.getRepository().getNormalizedUrls().getSecond()).substring(((String)this.getRepository().getNormalizedUrls().getFirst()).length());
            String relativePath = repositoryPath.substring(rootPath.length());
            String relativeToExternal = null;
            for (ExternalInfo external : externals) {
                String temp = FileUtils.getRelativePath((String)relativePath, (String)external.getCheckoutPath());
                if (temp == null || relativeToExternal != null && temp.length() >= relativeToExternal.length()) continue;
                relativeToExternal = temp;
                fileUrl = external.getUrl() + relativeToExternal;
                externalRevision = new SvnRevision(external.getRevision());
            }
        }
        if (revision == null) {
            revision = externalRevision;
        }
        if (revision == null) {
            revision = this.getRepository().getRevision();
        }
        if (fileUrl == null) {
            fileUrl = (String)this.getRepository().getNormalizedUrls().getFirst() + repositoryPath;
        }
        Commandline cmdline = this.getRepository().buildSvnCmd().addArgValue("info").addArgValue(fileUrl);
        this.getRepository().addAuthenticationSwitches(cmdline, this.getRepository().getUserName(), this.getRepository().getPassword());
        cmdline.addArgValue("--non-interactive");
        if (this.getRepository().isSupportTrustServerCert()) {
            cmdline.addArgValue("--trust-server-cert");
        }
        cmdline.addArgLine("--xml -r " + (Object)((Object)revision));
        final StringBuffer buffer = new StringBuffer();
        final boolean[] fileExists = new boolean[]{true};
        Commandline.ExecuteResult result = cmdline.execute((OutputStream)new LineConsumer("UTF-8"){

            public void consume(String line) {
                Context.getLogger().debug(line);
                buffer.append(line);
                buffer.append("\n");
            }
        }, new LineConsumer("UTF-8"){

            public void consume(String line) {
                Context.getLogger().warn(line);
                if (line.contains("Unable to find repository location for")) {
                    fileExists[0] = false;
                }
            }
        });
        if (!fileExists[0]) {
            return null;
        }
        result.checkReturnCode();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(buffer.toString()));
            Element entryElement = doc.getRootElement().element("entry");
            if (entryElement == null) {
                throw new QuickbuildException("Can not find entry element for information of url '" + fileUrl + "'.");
            }
            Attribute kindAttrib = entryElement.attribute("kind");
            if (kindAttrib == null) {
                throw new QuickbuildException("Can not find kind attribute inside the entry element.");
            }
            if (!kindAttrib.getValue().equals("file")) {
                return null;
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        File tempFile = FileUtils.createTempFile((String)"svnsourceview");
        try {
            cmdline.clearArgs().addArgValue("export").addArgValue(fileUrl).addArgValue(tempFile.getAbsolutePath()).addArgValue("--non-interactive");
            if (this.getRepository().isSupportTrustServerCert()) {
                cmdline.addArgValue("--trust-server-cert");
            }
            this.getRepository().addLogLevelSwitches(cmdline);
            this.getRepository().addAuthenticationSwitches(cmdline, this.getRepository().getUserName(), this.getRepository().getPassword());
            cmdline.addArgLine("--force -r " + (Object)((Object)revision));
            cmdline.execute(Bootstrap.getTempDir(), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            List list = FileUtils.readFileAsLines((File)tempFile);
            return list;
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }

    public List<String> readSourceByRevision(String repositoryPath, SvnRevision revision) {
        return this.readFile(repositoryPath, revision);
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return this.readFile(repositoryPath, new SvnRevision(edition));
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            String checkoutFileCanonicalPath = checkoutFile.getCanonicalPath();
            String destDirCanonicalPath = this.getRepository().getDestDir().getCanonicalPath();
            Context.getLogger().debug("Calculating repository path...");
            Context.getLogger().debug("Path to checkout file: " + checkoutFileCanonicalPath);
            Context.getLogger().debug("Path to repository destination directory: " + destDirCanonicalPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getDestDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        Validate.notNull(this.getRepository().getNormalizedUrls());
        return ((String)this.getRepository().getNormalizedUrls().getSecond()).substring(((String)this.getRepository().getNormalizedUrls().getFirst()).length()) + relativePath;
    }
}

