/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.svn;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.svn.SvnRepository;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class SvnProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private SvnRepository repository;
    private String workingCopies;
    private String userName;
    private String password;
    private String updateCondition = "true";
    private String commitCondition = "build.successful";
    private String commitComment;

    @Editable(order=100, description="Specify working copy paths at user's desktop. Local change will be collected from these working copies and sent to QuickBuild to run a proof build.<br><strong>NOTE:</strong> mutiple working copy paths need to be separated by comma or new line character.")
    @NotEmpty
    @ScriptApi(value="Get path of working copies at user's desktop to collect local change from.")
    @Scriptable
    public String getWorkingCopies() {
        return this.workingCopies;
    }

    public void setWorkingCopies(String workingCopies) {
        this.workingCopies = workingCopies;
    }

    @Editable(order=150, description="Optionally specify the Subversion user to be used at user's desktop.")
    @ScriptApi(value="Get user name to be used at user's desktop.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=160, description="Specify the Subversion password to be used at user's desktop.")
    @Password
    @ScriptApi(value="Get password to be used at user's desktop.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=200, description="Specify the condition to update working copies. If this condition is satisfied, the work copies specified above will be updated before local change is collected. Updating working copies will make the proof build more accurate and you should normally set this condition to <b>true</b>.")
    @Expressions(value={"always update", "true", "do not update", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to update working copies before collect local change.")
    @Scriptable
    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    @Editable(order=300, description="Specify the condition to commit local change. If this condition is satisfied, local change in the workspace specified above will be commit after the build finishes.")
    @Expressions(value={"commit only when build is successful", "build.successful", "always commit", "true", "do not commit", "false"})
    @NotEmpty
    @ScriptApi(value="Get the condition to commit local change after build finishes.")
    @Scriptable
    public String getCommitCondition() {
        return this.commitCondition;
    }

    public void setCommitCondition(String commitCondition) {
        this.commitCondition = commitCondition;
    }

    @Editable(order=400, description="Specify the comment when commit the local change. This property only takes effect if the commit condition specified above is satisfied.")
    @Multiline
    @ScriptApi(value="Get the comment to commit local change after build finishes. Null if not specified.")
    @Scriptable
    public String getCommitComment() {
        return this.commitComment;
    }

    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    public SvnProofBuildSupport(SvnRepository repository) {
        this.repository = repository;
    }

    private List<File> getWorkingCopyDirs() {
        ArrayList<File> workingCopies = new ArrayList<File>();
        for (String workingCopyPath : StringUtils.split((String)this.getWorkingCopies(), (String)"\n\r,")) {
            workingCopies.add(new File(workingCopyPath.trim()));
        }
        return workingCopies;
    }

    public void buildFinished() {
        Boolean isCommit = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getCommitCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isCommit.booleanValue()) {
            Context.getLogger().info("Committing local change...");
            for (File workingCopy : this.getWorkingCopyDirs()) {
                Commandline cmdline = this.repository.buildSvnCmd();
                cmdline.addArgLine("status . --no-ignore --non-interactive");
                if (this.repository.isSupportTrustServerCert()) {
                    cmdline.addArgValue("--trust-server-cert");
                }
                if (this.repository.isIgnoreExternals()) {
                    cmdline.addArgValue("--ignore-externals");
                }
                final ArrayList<String> externals = new ArrayList<String>();
                externals.add("");
                cmdline.execute(workingCopy, (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        Context.getLogger().debug(line);
                        if (line.startsWith("Performing status on external item at")) {
                            externals.add(StringUtils.replace((String)StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)line, (String)"'"), (String)"'"), (String)"\\", (String)"/"));
                        }
                    }
                }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                for (String external : externals) {
                    if (external.length() == 0) {
                        Context.getLogger().info("Checkin local change in working copy: " + workingCopy.getAbsolutePath());
                    } else {
                        Context.getLogger().info("Checkin local change in external '{}' of working copy '{}'...", (Object)external, (Object)workingCopy.getAbsolutePath());
                    }
                    cmdline = this.repository.buildSvnCmd().addArgValue("commit");
                    this.repository.addLogLevelSwitches(cmdline);
                    this.repository.addAuthenticationSwitches(cmdline, this.getUserName() != null ? this.getUserName() : this.repository.getUserName(), this.getPassword() != null ? this.getPassword() : this.repository.getPassword());
                    cmdline.addArgValue("--non-interactive");
                    if (this.repository.isSupportTrustServerCert()) {
                        cmdline.addArgValue("--trust-server-cert");
                    }
                    cmdline.addArgValue("-m");
                    if (this.getCommitComment() != null) {
                        cmdline.addArgValue(this.getCommitComment());
                    } else {
                        cmdline.addArgValue("Committed by QuickBuild as result of proof build.");
                    }
                    cmdline.execute(new File(workingCopy, external), (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
                }
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        String topRepositoryPath = ((String)this.repository.getNormalizedUrls().getSecond()).substring(((String)this.repository.getNormalizedUrls().getFirst()).length());
        if (FileUtils.getRelativePath((String)repositoryPath, (String)topRepositoryPath) != null) {
            String relativeRepositoryPath = repositoryPath.substring(topRepositoryPath.length());
            return new File(this.repository.getDestDir(), relativeRepositoryPath);
        }
        return null;
    }

    public LocalChange getLocalChange(File changeStoreDir) {
        Boolean isUpdate = (Boolean)((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getUpdateCondition(), Context.buildEvalContext((Object)((Object)this), null));
        if (isUpdate.booleanValue()) {
            Context.getLogger().info("Updating working copies...");
            for (File workingCopy : this.getWorkingCopyDirs()) {
                Context.getLogger().info("Updating working copy: " + workingCopy.getAbsolutePath());
                Commandline cmdline = this.repository.buildSvnCmd().addArgValue("update").addArgValue("--non-interactive");
                if (this.repository.isSupportTrustServerCert()) {
                    cmdline.addArgValue("--trust-server-cert");
                }
                this.repository.addAuthenticationSwitches(cmdline, this.getUserName(), this.getPassword());
                this.repository.addLogLevelSwitches(cmdline);
                cmdline.execute(workingCopy, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            }
        }
        Context.getLogger().info("Checking status of working copies...");
        LocalChange change = new LocalChange();
        for (File workingCopy : this.getWorkingCopyDirs()) {
            String repositoryPathForWorkingCopy = this.getRepositoryPathForWorkingCopy(workingCopy);
            this.calcLocalChange(change, workingCopy, repositoryPathForWorkingCopy, null, changeStoreDir);
        }
        return change;
    }

    private void calcLocalChange(LocalChange change, File workingCopy, String workingCopyRepoPath, String external, File changeStoreDir) {
        Commandline cmdline = this.repository.buildSvnCmd();
        cmdline.addArgLine("status");
        if (external == null) {
            cmdline.addArgValue(".");
        } else {
            cmdline.addArgValue(external);
        }
        cmdline.addArgValue("--no-ignore").addArgValue("--non-interactive");
        if (this.repository.isSupportTrustServerCert()) {
            cmdline.addArgValue("--trust-server-cert");
        }
        if (this.repository.isIgnoreExternals() || external != null) {
            cmdline.addArgValue("--ignore-externals");
        }
        final ArrayList<String> outputs = new ArrayList<String>();
        final ArrayList externals = new ArrayList();
        cmdline.execute(workingCopy, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                String entryPath;
                char action;
                Context.getLogger().debug(line);
                if (!(line.length() < 7 || (action = line.charAt(0)) != 'C' && action != '!' && action != '~' && action != '?' && action != 'D' && action != 'M' && action != 'A' && action != 'I' && action != 'R' || new File(entryPath = line.substring(7).trim()).isAbsolute())) {
                    outputs.add(StringUtils.replace((String)line, (String)"\\", (String)"/"));
                }
                if (line.startsWith("Performing status on external item at")) {
                    externals.add(StringUtils.replace((String)StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)line, (String)"'"), (String)"'"), (String)"\\", (String)"/"));
                }
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        HashSet<String> excludedHistoryChildPaths = new HashSet<String>();
        ArrayList<String> historyPaths = new ArrayList<String>();
        Iterator it = outputs.iterator();
        while (it.hasNext()) {
            boolean isHistory;
            String line = (String)it.next();
            String entryPath = line.substring(7).trim();
            char action = line.charAt(0);
            boolean bl = isHistory = line.charAt(3) == '+';
            if (line.charAt(6) == 'C') {
                throw new QuickbuildException("Failed to collect local change as tree conflict is found for path '" + new File(workingCopy, entryPath).getAbsolutePath() + "'.");
            }
            if (action == 'C') {
                throw new QuickbuildException("Failed to collect local change as conflict is found for path '" + new File(workingCopy, entryPath).getAbsolutePath() + "'.");
            }
            if (action == '!') {
                throw new QuickbuildException("Failed to collect local change as item is missing for path '" + new File(workingCopy, entryPath).getAbsolutePath() + "'.");
            }
            if (action == '~') {
                throw new QuickbuildException("Failed to collect local change as obstructed item is found for path '" + new File(workingCopy, entryPath).getAbsolutePath() + "'.");
            }
            if (action == '?' || action == 'D' || action == 'I' || action == 'M' || action == 'R' || action == 'A' && !isHistory) {
                excludedHistoryChildPaths.add(entryPath);
                continue;
            }
            if (action != 'A' || !isHistory) continue;
            historyPaths.add(entryPath);
            it.remove();
        }
        FileUtils.sortPaths(historyPaths);
        ArrayList<String> normalizedHistoryPaths = new ArrayList<String>();
        String previousHistoryPath = null;
        for (String historyPath : historyPaths) {
            if (previousHistoryPath != null && FileUtils.getRelativePath((String)historyPath, previousHistoryPath) != null) continue;
            normalizedHistoryPaths.add(historyPath);
            previousHistoryPath = historyPath;
        }
        for (String historyPath : normalizedHistoryPaths) {
            this.addHistoryChildPaths(workingCopy, historyPath, outputs, excludedHistoryChildPaths);
        }
        for (String line : outputs) {
            String entryPath = line.substring(7).trim();
            String entryRepositoryPath = workingCopyRepoPath + "/" + entryPath;
            File entryFile = new File(workingCopy, entryPath);
            File entryFileInStore = new File(changeStoreDir, entryRepositoryPath);
            char action = line.charAt(0);
            switch (action) {
                case 'M': 
                case 'R': {
                    if (entryFileInStore == null) break;
                    Validate.isTrue((boolean)entryFile.isFile());
                    FileUtils.copyFile((File)entryFile, (File)entryFileInStore);
                    if (this.isCoveredByHistory(normalizedHistoryPaths, entryPath)) {
                        change.getAddPaths().add(entryRepositoryPath);
                        break;
                    }
                    change.getModifyPaths().add(entryRepositoryPath);
                    if (external == null) break;
                    FileUtils.createFile((File)new File(entryFileInStore.getAbsolutePath() + ".qbprev"));
                    break;
                }
                case 'D': {
                    if (entryFileInStore == null || this.isCoveredByHistory(normalizedHistoryPaths, entryPath)) break;
                    change.getDeletePaths().add(entryRepositoryPath);
                    break;
                }
                case 'A': {
                    if (entryFileInStore == null) break;
                    if (entryFile.isFile()) {
                        FileUtils.copyFile((File)entryFile, (File)entryFileInStore);
                    } else {
                        FileUtils.createDir((File)entryFileInStore);
                    }
                    change.getAddPaths().add(entryRepositoryPath);
                }
            }
        }
        for (String each : externals) {
            this.calcLocalChange(change, workingCopy, workingCopyRepoPath, each, changeStoreDir);
        }
    }

    private void addHistoryChildPaths(File workingCopy, String historyPath, List<String> addTo, Set<String> exludedHistoryChildPaths) {
        if (!exludedHistoryChildPaths.contains(historyPath)) {
            addTo.add("A       " + historyPath);
            File historyFile = new File(workingCopy, historyPath);
            if (historyFile.isDirectory()) {
                for (File childFile : historyFile.listFiles()) {
                    if (childFile.getName().equals(".svn")) continue;
                    this.addHistoryChildPaths(workingCopy, historyPath + "/" + childFile.getName(), addTo, exludedHistoryChildPaths);
                }
            }
        }
    }

    private String getRepositoryPathForWorkingCopy(File workingCopy) {
        Commandline cmdline = this.repository.buildSvnCmd().addArgValue("info").addArgValue(workingCopy.getAbsolutePath());
        this.repository.addAuthenticationSwitches(cmdline, this.getUserName() != null ? this.getUserName() : this.repository.getUserName(), this.getPassword() != null ? this.getPassword() : this.repository.getPassword());
        cmdline.addArgValue("--non-interactive");
        if (this.repository.isSupportTrustServerCert()) {
            cmdline.addArgValue("--trust-server-cert");
        }
        cmdline.addArgValue("--xml");
        final StringBuffer buffer = new StringBuffer();
        cmdline.execute((OutputStream)new LineConsumer("UTF-8"){

            public void consume(String line) {
                Context.getLogger().debug(line);
                buffer.append(line);
                buffer.append("\n");
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(buffer.toString()));
            Element entryElement = doc.getRootElement().element("entry");
            if (entryElement == null) {
                throw new QuickbuildException("Can not find entry element for information of working copy '" + workingCopy.getAbsolutePath() + "'");
            }
            String workingCopyRootUrl = this.repository.decodeUrl(entryElement.element("repository").elementText("root"));
            String workingCopyUrl = this.repository.decodeUrl(entryElement.elementText("url"));
            return workingCopyUrl.substring(workingCopyRootUrl.length());
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private boolean isCoveredByHistory(List<String> historyPaths, String path) {
        for (String historyPath : historyPaths) {
            if (FileUtils.getRelativePath((String)path, (String)historyPath) == null) continue;
            return true;
        }
        return false;
    }

    @ScriptApi
    public SvnRepository getRepository() {
        return this.repository;
    }
}

