/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.equinoxadapter;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquinoxAdapter {
    public static final String ENTRY_CLASS = "com.pmease.quickbuild.Quickbuild";
    public static final Logger logger = LoggerFactory.getLogger(EquinoxAdapter.class);
    public static File systemDir;
    public static Map<String, File> pluginLocations;
    public static final String BOOTSTRAP_PLUGIN_ID = "com.pmease.quickbuild.bootstrap";
    public static final String ADAPTER_PLUGIN_ID = "com.pmease.quickbuild.equinoxadapter";
    public static final String QUICKBUILD_PLUGIN_ID = "com.pmease.quickbuild";
    public static final String LIBS_PLUGIN_ID = "com.pmease.quickbuild.libs";
    private static Class<?> managerClass;
    private static Object manager;

    public static void startup(String[] args, Runnable runnable) {
        pluginLocations = EquinoxAdapter.findPluginLocations();
        ClassLoader appClassLoader = EquinoxAdapter.buildAppClassLoader();
        Thread.currentThread().setContextClassLoader(appClassLoader);
        try {
            managerClass = appClassLoader.loadClass(ENTRY_CLASS);
            manager = managerClass.newInstance();
            managerClass.getMethod("start", new Class[0]).invoke(manager, new Object[0]);
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private static List<File> findJars(File dir) {
        ArrayList<File> libs = new ArrayList<File>();
        for (File each : dir.listFiles()) {
            if (each.isDirectory()) {
                libs.addAll(EquinoxAdapter.findJars(each));
                continue;
            }
            if (!each.isFile() || !each.getName().endsWith(".jar")) continue;
            libs.add(each);
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ClassLoader buildAppClassLoader() {
        if (Bootstrap.isAgent()) {
            if (EquinoxAdapter.getLibCacheDir().exists()) {
                try {
                    FileUtils.cleanDirectory((File)EquinoxAdapter.getLibCacheDir());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (!EquinoxAdapter.getLibCacheDir().mkdir()) {
                throw new RuntimeException("Failed to create lib cache directory: " + EquinoxAdapter.getLibCacheDir().getAbsolutePath());
            }
        }
        logger.info("Caching plugin libraries...");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File pluginLocation : pluginLocations.values()) {
                if (pluginLocation.isDirectory()) {
                    if (new File(pluginLocation, "WEB-INF/classes").exists()) {
                        urls.add(new File(pluginLocation, "WEB-INF/classes").toURI().toURL());
                    }
                    if (new File(pluginLocation, "bin").exists()) {
                        urls.add(new File(pluginLocation, "bin").toURI().toURL());
                    }
                    File libsDir = new File(pluginLocation, "lib").exists() ? new File(pluginLocation, "lib") : (new File(pluginLocation, "libs").exists() ? new File(pluginLocation, "libs") : pluginLocation);
                    for (File jarFile : EquinoxAdapter.findJars(libsDir)) {
                        urls.add(jarFile.toURI().toURL());
                    }
                    continue;
                }
                urls.add(pluginLocation.toURI().toURL());
                try {
                    JarFile jarFile = new JarFile(pluginLocation);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".jar") && !entry.getName().endsWith(".so") && !entry.getName().endsWith(".sl") && !entry.getName().endsWith(".dll") && !entry.getName().endsWith(".lib") && !entry.getName().endsWith(".exe") && !entry.getName().endsWith(".dylib") && !entry.getName().endsWith(".pdb") && !entry.getName().endsWith(".sh")) continue;
                        String libName = entry.getName();
                        File libFile = new File(EquinoxAdapter.getLibCacheDir(), libName);
                        if (!libFile.getParentFile().exists()) {
                            libFile.getParentFile().mkdirs();
                        }
                        if (!libFile.exists()) {
                            InputStream is = null;
                            FileOutputStream os = null;
                            try {
                                int len;
                                is = jarFile.getInputStream(entry);
                                os = new FileOutputStream(libFile);
                                byte[] bytes = new byte[65536];
                                while ((len = is.read(bytes)) != -1) {
                                    ((OutputStream)os).write(bytes, 0, len);
                                }
                            }
                            finally {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e) {}
                                }
                                if (os != null) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                        }
                        if (!libName.endsWith(".jar")) continue;
                        urls.add(libFile.toURI().toURL());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return new URLClassLoader(urls.toArray(new URL[0]), EquinoxAdapter.class.getClassLoader());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, File> findPluginLocations() {
        boolean checkPluginsDir;
        HashMap<String, File> pluginLocations = new HashMap<String, File>();
        if (Bootstrap.bootDir.equals(Bootstrap.installDir) && Bootstrap.devDir != null) {
            File metaDataDir = new File(Bootstrap.devDir, ".metadata/.plugins/org.eclipse.core.resources/.projects");
            for (File each : Bootstrap.devDir.listFiles()) {
                String pluginId;
                if (!each.isDirectory() || each.getName().equals(BOOTSTRAP_PLUGIN_ID) || each.getName().equals(ADAPTER_PLUGIN_ID) || each.getName().equals(LIBS_PLUGIN_ID) || !new File(metaDataDir, each.getName()).exists() || (pluginId = EquinoxAdapter.findPluginId(each)) == null || !new File(each, "build.properties").exists()) continue;
                pluginLocations.put(pluginId, each);
            }
            checkPluginsDir = !new File(Bootstrap.devDir, "com.pmease.quickbuild.bootstrap/build.properties").exists();
            systemDir = new File(Bootstrap.devDir, "system");
            if (!systemDir.exists() || !new File(metaDataDir, systemDir.getName()).exists()) {
                systemDir = null;
            }
        } else {
            checkPluginsDir = true;
        }
        if (checkPluginsDir) {
            for (File file : new File(Bootstrap.bootDir, "plugins").listFiles()) {
                String pluginId;
                if (file.getName().equals(BOOTSTRAP_PLUGIN_ID) || file.getName().equals(LIBS_PLUGIN_ID) || file.getName().startsWith(ADAPTER_PLUGIN_ID) || (pluginId = EquinoxAdapter.findPluginId(file)) == null || pluginLocations.containsKey(pluginId)) continue;
                pluginLocations.put(pluginId, file);
            }
        }
        return pluginLocations;
    }

    public static String findPluginId(File pluginLocation) {
        Manifest manifest = EquinoxAdapter.findManifest(pluginLocation);
        if (manifest != null) {
            String attribute = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            int pos = attribute.indexOf(59);
            if (pos != -1) {
                return attribute.substring(0, pos);
            }
            return attribute;
        }
        return null;
    }

    public static Manifest findManifest(File jarLocation) {
        if (jarLocation.isDirectory()) {
            File manifestFile = new File(jarLocation, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                return null;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(manifestFile);
                Manifest manifest = new Manifest(is);
                return manifest;
            }
            catch (Exception e) {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (!jarLocation.getName().endsWith(".jar")) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarLocation);
            Manifest is = jarFile.getManifest();
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static File getLibCacheDir() {
        return new File(Bootstrap.bootDir, "framework/configuration/org.eclipse.osgi");
    }

    public static void shutdown() {
        try {
            managerClass.getMethod("stop", new Class[0]).invoke(manager, new Object[0]);
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }
}

