/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cpd;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cpd.DuplicateFile;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.web.ImageLinkPanel;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.error.ErrorMessagePage;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DuplicationPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public DuplicationPanel(String id, IModel<ItemContext> model) {
        super(id, model);
        DataRow row = this.getRow();
        List files = (List)row.getValue("duplicateFiles");
        if (files.isEmpty()) {
            this.setVisible(false);
        } else {
            this.add(new Component[]{new FilesView("fileInfo", files)});
            String codefragment = row.getValueAsString("codefragment");
            WebMarkupContainer sourceContainer = new WebMarkupContainer("sourceContainer");
            this.add(new Component[]{sourceContainer});
            if (StringUtils.isEmpty((String)codefragment)) {
                sourceContainer.setVisible(false);
            } else {
                DuplicateFile file = (DuplicateFile)files.get(0);
                String extension = FilenameUtils.getExtension((String)file.getPath());
                String html = ReportHelper.renderSource((String)codefragment, (String)extension);
                sourceContainer.add(new Component[]{new Label("source", html).setEscapeModelStrings(false)});
            }
        }
    }

    private ItemContext getContext() {
        return (ItemContext)this.getDefaultModelObject();
    }

    private DataRow getRow() {
        return this.getContext().getDataRow();
    }

    public String java2Html(String source) {
        return ReportHelper.renderSource((String)source, (String)"java");
    }

    private class FilesView
    extends ListView<DuplicateFile> {
        private static final long serialVersionUID = 1L;

        public FilesView(String id, List<DuplicateFile> list) {
            super(id, list);
        }

        protected void populateItem(ListItem<DuplicateFile> item) {
            final DuplicateFile file = (DuplicateFile)item.getDefaultModelObject();
            item.add(new Component[]{new Label("path", file.getPath())});
            item.add(new Component[]{new Label("line", String.valueOf(file.getLine()))});
            item.add(new Component[]{new ImageLinkPanel("viewSource", (IModel)new Model((Serializable)((Object)"/images/report/viewsource.gif"))){
                private static final long serialVersionUID = 1L;

                protected AbstractLink createLink(String id) {
                    Link<Void> link = new Link<Void>(id){
                        private static final long serialVersionUID = 1L;

                        public void onClick() {
                            FilesView.this.doViewSource(file);
                        }
                    };
                    link.setPopupSettings(new PopupSettings("popup", 12));
                    link.setVisible(SecurityHelper.hasPermission((String)ConfigurationPermission.VIEW_SOURCE.name()));
                    return link;
                }
            }.setRenderBodyOnly(true)});
        }

        private void doViewSource(DuplicateFile duplicate) {
            String fileName = duplicate.getPath();
            String title = "Source of: " + fileName;
            String sourceType = FilenameUtils.getExtension((String)fileName);
            ArrayList<Block> blocks = new ArrayList<Block>();
            List lines = null;
            Build build = Context.getBuild();
            lines = build.readSourceFile(fileName);
            if (lines == null) {
                this.setResponsePage((Page)new ErrorMessagePage("Error", "File not found in repository: " + fileName));
                return;
            }
            if (lines.isEmpty()) {
                this.setResponsePage((Page)new ErrorMessagePage("Error", "The lines of source file " + fileName + " is zero."));
                return;
            }
            DataRow row = DuplicationPanel.this.getRow();
            Integer totalLines = row.getInt("lines");
            Block block = new Block();
            block.setColor("#FF1A00");
            int startLine = duplicate.getLine();
            block.setStartLine(startLine);
            block.setEndLine(startLine + totalLines);
            blocks.add(block);
            this.setResponsePage((Page)new SourceViewPage(title, sourceType, lines.toArray(new String[0]), blocks.toArray(new Block[blocks.size()])));
        }
    }
}

