/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cpd;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cpd.CPDPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;

@Editable(category={"Publish"}, name="CPD Report", description="Publish CPD reports")
@ScriptApi(value="This step publishes the original CPD XML files.")
public class CPDPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int totals;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CPDPlugin.class);
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"duplicationsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"all_duplications", (String)reportsetName)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "CPDPublisher::saveStatsReport");
            Long count = db.queryForLong("SELECT COUNT(*) FROM duplications");
            DataRow row = statsReport.addRow();
            row.setValue("buildId", (Object)context.getCurrentBuild().getId());
            row.setValue("duplications", (Object)count);
            this.totals = count.intValue();
        }
        finally {
            db.close();
        }
        category.saveReport(dbDir, statsReport);
    }

    @ScriptApi(value="Total duplications in CPD report.")
    public int getTotals() {
        return this.totals;
    }

    public void setTotals(int totals) {
        this.totals = totals;
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return CPDChecksum.class;
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        CPDPublisher.removeElement((VersionedDocument)dom, (String)"totals");
    }

    public static class CPDChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(CPDPlugin.class);
        }
    }
}

