/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cpd;

import com.pmease.quickbuild.plugin.report.cpd.DuplicateFile;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.dom4j.Element;
import org.dom4j.Node;

public class CPDProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public CPDProcessor(ReportCategory category) {
        super(category);
    }

    protected void processCurrentElement() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        Element element = context.getCurrentElement();
        destRow.setValue("uid", (Object)UUID.randomUUID().toString());
        destRow.setValue("lines", (Object)XMLHelper.getIntOfXPath((Node)element, (String)"./@lines"));
        destRow.setValue("tokens", (Object)XMLHelper.getIntOfXPath((Node)element, (String)"./@tokens"));
        destRow.setValue("codefragment", (Object)XMLHelper.getStringOfXPath((Node)element, (String)"./codefragment"));
        ArrayList<DuplicateFile> files = new ArrayList<DuplicateFile>();
        List nodes = element.selectNodes("./file");
        String workspacePath = context.getWorkspaceDir();
        for (Element node : nodes) {
            DuplicateFile file = new DuplicateFile();
            file.setLine(XMLHelper.getIntOfXPath((Node)node, (String)"./@line"));
            String path = XMLHelper.getStringOfXPath((Node)node, (String)"./@path");
            path = ReportUtils.getRelativePath((String)path, (String)workspacePath);
            file.setPath(path);
            files.add(file);
        }
        destRow.setValue("duplicateFiles", files);
    }
}

