/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.boosttest;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.boosttest.BoostTestPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.xunit.XUnitPublisher;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.Map;

@Editable(category={"Publish"}, name="Boost Test Report", description="Publish Boost Test reports")
@ScriptApi(value="This step publishes the original Boost Test XML files.")
public class BoostTestPublisher
extends XUnitPublisher {
    private static final long serialVersionUID = 1L;

    protected Class<? extends NodeJob> getChecksumJob() {
        return BoostTestChecksum.class;
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_tests", (String)reportsetName)).put((Object)"failedTestsUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"failed_tests", (String)reportsetName)).build();
    }

    public static class BoostTestChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(BoostTestPlugin.class);
        }
    }
}

