/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.boosttest;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.xunit.XUnitCategory;
import com.pmease.quickbuild.plugin.report.xunit.generator.AbstractTestProcessor;
import com.pmease.quickbuild.plugin.report.xunit.generator.TestStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class BoostTestCategory
extends XUnitCategory {
    private static final long serialVersionUID = 1L;

    public String getId() {
        return "boost";
    }

    public String getName() {
        return "Boost Test";
    }

    protected AbstractProcessor getTestProcessor() {
        return new AbstractTestProcessor((ReportCategory)this){
            private static final long serialVersionUID = 1L;

            public String getXPathOfTestCase() {
                return "//TestCase";
            }

            protected String getSuiteName(Element node) {
                Element root = node.getDocument().getRootElement();
                Vector<String> v = new Vector<String>();
                for (Element parent = node.getParent(); parent != null && parent != root; parent = parent.getParent()) {
                    String name = parent.attributeValue("name");
                    v.add(name);
                }
                Collections.reverse(v);
                return Joiner.on((String)"::").skipNulls().join(v);
            }

            protected String getTestName(Element node) {
                return node.attributeValue("name");
            }

            protected TestStatus getStatus(Element node) {
                TestStatus status = TestStatus.PASS;
                if (node.elements("Error").size() > 0 || node.elements("FatalError").size() > 0 || node.elements("Exception").size() > 0) {
                    status = TestStatus.FAIL;
                }
                return status;
            }

            protected long getDuration(Element node) {
                Long d;
                Element e = node.element("TestingTime");
                if (e != null && (d = (Long)DataTypes.LONG.fromString(e.getText(), null)) != null) {
                    d = d / 1000L;
                    return d;
                }
                return 0L;
            }

            protected List<String> getErrorTypes(Element node) {
                Element n;
                ArrayList list = Lists.newArrayList();
                for (Object each : node.elements("Exception")) {
                    n = (Element)each;
                    list.add("Exception at [" + n.attributeValue("file") + ", line: " + n.attributeValue("line") + "]");
                }
                for (Object each : node.elements("FatalError")) {
                    n = (Element)each;
                    list.add("FatalError at [" + n.attributeValue("file") + ", line: " + n.attributeValue("line") + "]");
                }
                for (Object each : node.elements("Error")) {
                    n = (Element)each;
                    list.add("Error at [" + n.attributeValue("file") + ", line: " + n.attributeValue("line") + "]");
                }
                return list;
            }

            protected List<String> getErrorMessages(Element node) {
                Element n;
                ArrayList list = Lists.newArrayList();
                for (Object each : node.elements("Exception")) {
                    n = (Element)each;
                    list.add(n.getText());
                }
                for (Object each : node.elements("FatalError")) {
                    n = (Element)each;
                    list.add(n.getText());
                }
                for (Object each : node.elements("Error")) {
                    n = (Element)each;
                    list.add(n.getText());
                }
                return list;
            }

            protected List<String> getMessages(Element node) {
                ArrayList list = Lists.newArrayList();
                for (Object each : node.elements("Message")) {
                    Element n = (Element)each;
                    list.add(n.getText() + " - at [" + n.attributeValue("file") + ", line: " + n.attributeValue("line") + "]");
                }
                return list;
            }
        };
    }
}

