/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.gradle;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.builder.gradle.GradleSetting;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Environment;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Gradle", order=25, category={"Build"}, description="Configure a Gradle based build step here. By default, QuickBuild executes \"gradle\" (or gradle.bat on Windows) to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Gradle plugin through the plugin management page.")
@ScriptApi(value="This step calls Gradle to build projects.")
public class GradleBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String gradleWrapperPath;
    private String workingPath;
    private String projectPath;
    private String buildScriptPath;
    private String buildTasks;
    private List<Property> systemProperties = new ArrayList<Property>();
    private List<Property> projectProperties = new ArrayList<Property>();
    private String extraGradleOptions;
    private List<Property> environments = new ArrayList<Property>();
    private int returnCode;

    @Editable(name="Path to Gradle Wrapper", order=1050, description="Optionally specify path to gradle wrapper. For instance: <i>build/gradlew.bat</i>. If specified, QuickBuild will use the wrapper to run this step, instead of using the gradle path specified in gradle plugin setting. A relative path for this setting is considered to be relative to the workspace directory.")
    @Scriptable
    public String getGradleWrapperPath() {
        return this.gradleWrapperPath;
    }

    public void setGradleWrapperPath(String gradleWrapperPath) {
        this.gradleWrapperPath = gradleWrapperPath;
    }

    @Editable(order=1100, name="Gradle Build File", description="Specify the path to the Gradle build file. A non-absolute path is considered to be relative to the working directory (working directory will be the same as configuration workspace directory if not specified explicitly in advanced setting of this step).")
    @NotEmpty
    @ScriptApi(value="Get Gradle build file path.")
    @Scriptable
    public String getBuildScriptPath() {
        return this.buildScriptPath;
    }

    public void setBuildScriptPath(String buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
    }

    @Editable(order=1200, description="Specify the tasks to build. Use space to separate different tasks (task name containing spaces should be quoted in order not to be interpreted as multiple tasks). If not specified, Gradle will try to execute default tasks.")
    @ScriptApi(value="Get build tasks.")
    @Scriptable
    public String getBuildTasks() {
        return this.buildTasks;
    }

    public void setBuildTasks(String buildTasks) {
        this.buildTasks = buildTasks;
    }

    @Editable(order=1300, description="Define system properties here to pass into gradle.<br><b>NOTE:</b> Properties with blank value will be ignored.")
    @ScriptApi(value="Get system properties passed to Gradle.")
    public List<Property> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(List<Property> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Editable(order=1310, description="Define project properties here to pass into the build script. For example, you may pass version of current build as project property <i>buildVersion</i> by specifying property name as <i>buildVersion</i> and property value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Properties with blank value will be ignored.")
    @ScriptApi(value="Get project properties passed to build script.")
    public List<Property> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(List<Property> projectProperties) {
        this.projectProperties = projectProperties;
    }

    @Editable(order=1400, name="Working Directory", description="Optionally specify working directory for Gradle. A non-absolute path is considered to be relative to the configuration workspace directory. If not specified, the configuration workspace directory will be used.")
    @ScriptApi(value="Get working directory of Gradle. Null if configuration workspace directory is used as working directory.")
    @Scriptable
    @Advanced
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @Editable(order=1410, name="Project Directory", description="Optionally specify project directory to run Gradle. A non-absolute path is considered to be relative to the working directory specified above. If not specified, the working directory above will be used.")
    @ScriptApi(value="Get project directory of Gradle. Null if working directory is used as project directory.")
    @Scriptable
    @Advanced
    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    @Editable(order=1500, description="Specify extra Gradle options. If specified, it will be appended to the Gradle global options specified in Gradle plugin setting. Please note that you should NOT specify below options as they'll be determined by QuickBuild:<br><b>-b, --buildfile, -d, --debug, -i, --info, -q, --quiet, -p, --project-dir, -P, --project-prop, -D, --system-prop</b>")
    @ScriptApi(value="Get extra options to run Gradle. Null if not specified.")
    @Scriptable
    @Advanced
    public String getExtraGradleOptions() {
        return this.extraGradleOptions;
    }

    public void setExtraGradleOptions(String extraGradleOptions) {
        this.extraGradleOptions = extraGradleOptions;
    }

    @Editable(name="Environment Variables", order=1600, description="Specify environment variables for Gradle execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> <ul><li>You may define environment variable <i>JAVA_HOME</i> here in order to build with your choosed JDK.<li>Environment variables with blank value will be ignored.</li></ul>")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @ScriptApi(value="Get return code of Gradle command.")
    public int getReturnCode() {
        return this.returnCode;
    }

    private Commandline getBuildCmd() {
        String extraGradleOptions;
        Commandline cmdline = new Commandline();
        cmdline.setExecutable(this.getGradleExecutable());
        String globalOpts = ((GradleSetting)this.getPlugin().getSetting(true)).getGradleOptions();
        if (StringUtils.isNotBlank((String)globalOpts)) {
            cmdline.createArgument().setLine(StringUtils.remove((String)globalOpts, (String)"-noclasspath"));
        }
        if ((extraGradleOptions = this.getExtraGradleOptions()) != null) {
            cmdline.createArgument().setLine(StringUtils.remove((String)extraGradleOptions, (String)"-noclasspath"));
        }
        for (Property property : this.getSystemProperties()) {
            if (!StringUtils.isNotBlank((String)property.getValue())) continue;
            cmdline.createArgument().setValue("-D" + property.getName() + "=" + property.getValue());
        }
        for (Property property : this.getProjectProperties()) {
            if (!StringUtils.isNotBlank((String)property.getValue())) continue;
            cmdline.createArgument().setValue("-P" + property.getName() + "=" + property.getValue());
        }
        if (Context.getLogger().isTraceEnabled()) {
            cmdline.createArgument().setValue("-d -S");
        } else if (Context.getLogger().isDebugEnabled()) {
            cmdline.createArgument().setValue("-d");
        } else if (Context.getLogger().isInfoEnabled()) {
            cmdline.createArgument().setValue("-i");
        } else {
            cmdline.createArgument().setValue("-q");
        }
        cmdline.createArgument().setValue("-p");
        cmdline.createArgument().setValue(this.getProjectDir().getAbsolutePath());
        File buildScriptFile = FileUtils.resolvePath((File)this.getWorkingDir(), (String)this.getBuildScriptPath());
        cmdline.createArgument().setValue("-b");
        cmdline.createArgument().setValue(buildScriptFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.getBuildTasks())) {
            cmdline.createArgument().setLine(this.getBuildTasks());
        }
        return cmdline;
    }

    private File getWorkingDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getWorkingPath());
    }

    private File getProjectDir() {
        return FileUtils.resolvePath((File)this.getWorkingDir(), (String)this.getProjectPath());
    }

    private String getGradleExecutable() {
        String gradleWrapperExe = this.getGradleWrapperPath();
        if (gradleWrapperExe != null) {
            return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)gradleWrapperExe).getAbsolutePath();
        }
        String gradleExe = ((GradleSetting)this.getPlugin().getSetting(true)).getGradleExecutablePath();
        if (gradleExe == null) {
            gradleExe = SystemUtils.IS_OS_WINDOWS ? "gradle.bat" : "gradle";
        }
        return gradleExe;
    }

    public void run() {
        Commandline cmdline = this.getBuildCmd();
        Environment env = new Environment();
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        final StringBuffer errorMessages = new StringBuffer();
        this.returnCode = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(){

            public void consume(String line) {
                if (line.contains("[INFO]")) {
                    Context.getLogger().info(StringUtils.substringAfter((String)line, (String)"[INFO]").trim());
                } else if (line.contains("[DEBUG]")) {
                    Context.getLogger().debug(StringUtils.substringAfter((String)line, (String)"[DEBUG]").trim());
                } else if (line.contains("[QUIET]")) {
                    Context.getLogger().info(StringUtils.substringAfter((String)line, (String)"[QUIET]").trim());
                } else if (line.contains("[LIFECYCLE]")) {
                    Context.getLogger().debug(StringUtils.substringAfter((String)line, (String)"[LIFECYCLE]").trim());
                } else if (line.contains("[ERROR]")) {
                    Context.getLogger().error(StringUtils.substringAfter((String)line, (String)"[ERROR]").trim());
                } else if (line.contains("[WARN]")) {
                    Context.getLogger().warn(StringUtils.substringAfter((String)line, (String)"[WARN]").trim());
                } else {
                    Context.getLogger().info(line);
                }
            }
        }, new LineConsumer(){

            public void consume(String line) {
                Context.getLogger().error(line);
                if (errorMessages.length() == 0) {
                    errorMessages.append(line);
                } else {
                    errorMessages.append("\n" + line);
                }
            }
        }).getReturnCode();
        if (this.returnCode != 0) {
            String exceptionMessage = "Gradle build failed.";
            if (errorMessages.length() != 0) {
                exceptionMessage = exceptionMessage + "\n" + errorMessages.toString();
            }
            throw new QuickbuildException(exceptionMessage);
        }
    }
}

