/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.passive;

import com.google.inject.Inject;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.extensionpoint.SimpleNotifier;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.notifier.passive.NotificationResource;
import com.pmease.quickbuild.plugin.notifier.passive.NotificationResource2;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class PassivePlugin
extends AbstractPlugin {
    @Inject
    private TaskScheduler scheduler;
    @Inject
    private UserManager userManager;
    private Map<Long, List<Build>> builds = new HashMap<Long, List<Build>>();
    private Map<Long, List<Alert>> alerts = new HashMap<Long, List<Alert>>();
    private String cleanupTaskId;
    private static final long CLEANUP_INTERVAL = 3600L;

    public Object[] getExtensions() {
        return new Object[]{new RestResourceContribution(){

            public Set<Class<?>> getResourceClasses() {
                HashSet classes = new HashSet();
                classes.add(NotificationResource.class);
                classes.add(NotificationResource2.class);
                return classes;
            }
        }, new SimpleNotifier(){

            public String getName() {
                return "Tray Monitor & IDE Plugins";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(Set<User> users, Build build) {
                Map map = PassivePlugin.this.builds;
                synchronized (map) {
                    for (User user : users) {
                        if (user.getId() == null) continue;
                        PassivePlugin.this.getUserBuilds(user).add(build);
                    }
                }
            }

            public void notify(NodeAlertEvent event) {
            }
        }};
    }

    private List<Build> getUserBuilds(User user) {
        List<Build> userBuilds = this.builds.get(user.getId());
        if (userBuilds == null) {
            userBuilds = new ArrayList<Build>();
            this.builds.put(user.getId(), userBuilds);
        }
        return userBuilds;
    }

    private List<Alert> getUserAlerts(User user) {
        List<Alert> userAlerts = this.alerts.get(user.getId());
        if (userAlerts == null) {
            userAlerts = new ArrayList<Alert>();
            this.alerts.put(user.getId(), userAlerts);
        }
        return userAlerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Build> getApplicableUserBuilds(User user, Long lastNotifiedBuildId) {
        Map<Long, List<Build>> map = this.builds;
        synchronized (map) {
            ArrayList<Build> applicableUserBuilds = new ArrayList<Build>();
            ArrayList<Build> userBuilds = new ArrayList<Build>();
            for (Build build : this.getUserBuilds(user)) {
                userBuilds.add(build);
            }
            if (lastNotifiedBuildId != null) {
                boolean found = false;
                for (Build build : userBuilds) {
                    if (found) {
                        applicableUserBuilds.add(build);
                        continue;
                    }
                    if (!build.getId().equals(lastNotifiedBuildId)) continue;
                    found = true;
                }
                if (!found) {
                    applicableUserBuilds.addAll(userBuilds);
                }
            } else if (!userBuilds.isEmpty()) {
                applicableUserBuilds.add((Build)userBuilds.get(userBuilds.size() - 1));
            }
            return applicableUserBuilds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Alert> getApplicableUserAlerts(User user, Long lastNotifiedAlertId) {
        Map<Long, List<Alert>> map = this.alerts;
        synchronized (map) {
            ArrayList<Alert> applicableUserAlerts = new ArrayList<Alert>();
            ArrayList<Alert> userAlerts = new ArrayList<Alert>();
            for (Alert alert : this.getUserAlerts(user)) {
                userAlerts.add(alert);
            }
            if (lastNotifiedAlertId != null) {
                boolean found = false;
                for (Alert alert : userAlerts) {
                    if (found) {
                        applicableUserAlerts.add(alert);
                        continue;
                    }
                    if (!alert.getId().equals(lastNotifiedAlertId)) continue;
                    found = true;
                }
                if (!found) {
                    applicableUserAlerts.addAll(userAlerts);
                }
            } else if (!userAlerts.isEmpty()) {
                applicableUserAlerts.add((Alert)userAlerts.get(userAlerts.size() - 1));
            }
            return applicableUserAlerts;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.cleanupTaskId = this.scheduler.schedule(new SchedulableTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                Iterator it2;
                Map.Entry entry;
                Iterator it;
                Date threshold;
                Map map = PassivePlugin.this.builds;
                synchronized (map) {
                    threshold = new Date(System.currentTimeMillis() - 3600000L);
                    it = PassivePlugin.this.builds.entrySet().iterator();
                    while (it.hasNext()) {
                        entry = it.next();
                        if (PassivePlugin.this.userManager.get((Long)entry.getKey()) == null) {
                            it.remove();
                            continue;
                        }
                        it2 = ((List)entry.getValue()).iterator();
                        while (it2.hasNext()) {
                            Build build = (Build)it2.next();
                            if (!build.getEndDate().before(threshold)) continue;
                            it2.remove();
                        }
                    }
                }
                map = PassivePlugin.this.alerts;
                synchronized (map) {
                    threshold = new Date(System.currentTimeMillis() - 3600000L);
                    it = PassivePlugin.this.alerts.entrySet().iterator();
                    while (it.hasNext()) {
                        entry = it.next();
                        if (PassivePlugin.this.userManager.get((Long)entry.getKey()) == null) {
                            it.remove();
                            continue;
                        }
                        it2 = ((List)entry.getValue()).iterator();
                        while (it2.hasNext()) {
                            Alert alert = (Alert)it2.next();
                            if (!new Date(alert.getCtime()).before(threshold)) continue;
                            it2.remove();
                        }
                    }
                }
            }

            public Schedule getSchedule() {
                PeriodicalSchedule schedule = new PeriodicalSchedule();
                schedule.setRepeatInterval("3600");
                return schedule;
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduler.unschedule(this.cleanupTaskId);
        super.stop(context);
    }

    public PluginCategory getCategory() {
        return PluginCategory.NOTIFIER;
    }
}

