/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.passive;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.notifier.passive.Notifications;
import com.pmease.quickbuild.plugin.notifier.passive.PassivePlugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;

@Path(value="/notifications2")
public class NotificationResource2 {
    @GET
    public Notifications get(@QueryParam(value="last_notified_build_id") Long lastNotifiedBuildId, @QueryParam(value="last_notified_alert_id") Long lastNotifiedAlertId) {
        if (Context.getUser() == null) {
            throw new AccessDeniedException();
        }
        Notifications notifications = new Notifications();
        PluginManager pluginManager = (PluginManager)Quickbuild.getInstance(PluginManager.class);
        PassivePlugin plugin = (PassivePlugin)pluginManager.getPlugin(PassivePlugin.class);
        List<Build> builds = plugin.getApplicableUserBuilds(Context.getUser(), lastNotifiedBuildId);
        Collections.sort(builds, new Comparator<Build>(){

            @Override
            public int compare(Build build1, Build build2) {
                return (int)(build1.getId() - build2.getId());
            }
        });
        notifications.setBuilds(builds);
        List<Alert> alerts = plugin.getApplicableUserAlerts(Context.getUser(), lastNotifiedAlertId);
        Collections.sort(alerts, new Comparator<Alert>(){

            @Override
            public int compare(Alert alert1, Alert alert2) {
                return (int)(alert1.getId() - alert2.getId());
            }
        });
        notifications.setAlerts(alerts);
        return notifications;
    }
}

