/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.passive;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.AlertManager;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.notifier.passive.PassivePlugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/notifications")
public class NotificationResource {
    static final int MAX_ALERTS_SIZE = 1024;

    @GET
    public List<Build> get(@QueryParam(value="last_notified_build_id") Long lastNotifiedBuildId) {
        if (Context.getUser() == null) {
            throw new AccessDeniedException();
        }
        PluginManager pluginManager = (PluginManager)Quickbuild.getInstance(PluginManager.class);
        PassivePlugin plugin = (PassivePlugin)pluginManager.getPlugin(PassivePlugin.class);
        List<Build> notifications = plugin.getApplicableUserBuilds(Context.getUser(), lastNotifiedBuildId);
        Collections.sort(notifications, new Comparator<Build>(){

            @Override
            public int compare(Build notification1, Build notification2) {
                return (int)(notification1.getId() - notification2.getId());
            }
        });
        return notifications;
    }

    @Path(value="/alerts")
    @GET
    public List<Alert> getAlerts(@QueryParam(value="last_notified_time") Long lastNotifiedTime, @QueryParam(value="notifier_type") String notifierType) {
        User user = Context.getUser();
        List alarms = CacheManager.instance.getUserAlarms(user.getId());
        boolean subscribed = false;
        for (Alarm each : alarms) {
            if (!each.getNotifier().equalsIgnoreCase(notifierType)) continue;
            subscribed = true;
            break;
        }
        if (!subscribed) {
            return Collections.emptyList();
        }
        if (lastNotifiedTime == null) {
            lastNotifiedTime = TimeUtils.ago((long)3600000L);
        }
        List alerts = AlertManager.instance.getLastNFromCache(1024);
        ArrayList actual = Lists.newArrayList();
        for (Alert each : alerts) {
            if (each.getCtime() <= lastNotifiedTime) continue;
            actual.add(each);
        }
        return actual;
    }

    protected static WebApplicationException buildException(int status, String msg) {
        return new WebApplicationException(Response.status((int)status).entity((Object)msg).type("text/plain").build());
    }
}

