/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.utils;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String RESOURCE_KEY = "com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin";

    public static String shortHash(String original) {
        return original.substring(0, 12);
    }

    public static String stripEnd(String str, String stripChars) {
        int end = Utils.getStripEnd(str, stripChars);
        return end < 0 ? str : str.substring(0, end);
    }

    private static int getStripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return end;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end;
    }

    public static String normalizeUrl(String url) {
        return Utils.stripEnd(url, "/\\");
    }

    public static String formatDuration(Long mils) {
        if (mils == 0L) {
            return "0 mil";
        }
        if (mils < 1000L) {
            return mils + " mils";
        }
        return DurationFormatUtils.formatDurationWords((long)mils, (boolean)true, (boolean)true);
    }

    public static Map<String, String> stringToMap(String str) {
        String[] lines;
        LinkedHashMap<String, String> associations = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty((String)str)) {
            return associations;
        }
        for (String each : lines = StringUtils.split((String)str, (char)'\n')) {
            int pos;
            if (StringUtils.isBlank((String)each) || (pos = each.indexOf(61)) <= 0) continue;
            String key = each.substring(0, pos);
            String value = each.substring(pos + 1);
            associations.put(key.trim(), value);
        }
        return associations;
    }

    public static String mapToString(Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            String value = map.get(key);
            sb.append(key).append('=').append(value).append('\n');
        }
        return sb.toString();
    }

    private static final String formatAge(int dur, String unit) {
        if (dur == 1) {
            if ("hour".equalsIgnoreCase(unit)) {
                return "an hour ago";
            }
            return "a " + unit + " ago";
        }
        return dur + " " + unit + "s ago";
    }

    public static String formatAge(Date date) {
        DateTime dtBefore = new DateTime((Object)date);
        Date now = new Date();
        DateTime dtNow = new DateTime((Object)now);
        Period period = new Period((ReadableInstant)dtBefore, (ReadableInstant)dtNow);
        int years = period.getYears();
        if (years > 0) {
            return Utils.formatAge(years, "year");
        }
        int months = period.getMonths();
        if (months > 0) {
            return Utils.formatAge(months, "month");
        }
        int weeks = period.getWeeks();
        if (weeks > 0) {
            return Utils.formatAge(weeks, "week");
        }
        int days = period.getDays();
        int hours = period.getHours();
        if (days > 0) {
            if (days >= 1 && days < 2) {
                return "yesterday";
            }
            return Utils.formatAge(days, "day");
        }
        if (hours > 0) {
            if (hours < 6) {
                return Utils.formatAge(hours, "hour");
            }
            if (dtNow.getDayOfYear() - dtBefore.getDayOfYear() == 1) {
                return "yesterday";
            }
            return Utils.formatAge(hours, "hour");
        }
        int minutes = period.getMinutes();
        if (minutes > 0) {
            return Utils.formatAge(minutes, "minute");
        }
        int seconds = period.getSeconds();
        if (seconds > 0) {
            return Utils.formatAge(seconds, "second");
        }
        return "just now";
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null) {
            return false;
        }
        if (date2 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static String formatDate(Date date) {
        return Utils.formatDate(date, "MMMMM dd, yyyy");
    }

    public static String formatDate(Date date, String pattern) {
        return DateTimeFormat.forPattern((String)pattern).print((ReadableInstant)new DateTime((Object)date));
    }
}

