/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.model;

import com.pmease.quickbuild.addons.jira.service.QuickBuild;
import com.pmease.quickbuild.addons.jira.utils.Utils;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildFragment
implements Serializable,
Comparable<BuildFragment> {
    private static final long serialVersionUID = 1L;
    private final QuickBuild server;
    private Long id;
    private String configurationPath;
    private String version;
    private String status;
    private Date beginDate;
    private Long duration;
    private boolean scheduled;
    private String requester;
    private boolean deleted;
    public static final String[] ATTRIBUTES = new String[]{"id", "version", "status", "beginDate", "duration", "scheduled"};

    public BuildFragment(QuickBuild server) {
        this.server = server;
    }

    public QuickBuild getServer() {
        return this.server;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getFormattedDuration() {
        return Utils.formatDuration(this.duration);
    }

    public Date getEndDate() {
        if (this.getDuration() == null) {
            return null;
        }
        return new Date(this.getBeginDate().getTime() + this.getDuration());
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String triggeredBy) {
        this.requester = triggeredBy;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean isScheduled) {
        this.scheduled = isScheduled;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public String formatAsLink() {
        if (this.isDeleted()) {
            return "<em title=\"Build is deleted or not found.\">N/A</em>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a target=\"_blank\" class=\"qbbuild-link status-").append(this.getStatus().toLowerCase()).append("\" href=\"").append(Utils.normalizeUrl(this.server.getHost())).append("/build/").append(this.getId()).append("\">").append(this.getVersion()).append("</a>");
        return sb.toString();
    }

    @Override
    public int compareTo(BuildFragment other) {
        if (other == null) {
            return 1;
        }
        return this.id.compareTo(other.id);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BuildFragment)) {
            return false;
        }
        BuildFragment rhs = (BuildFragment)other;
        return this.getId().equals(rhs.getId());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id: ").append(this.id).append(", Path: ").append(this.configurationPath).append(", Version: ").append(this.version).append(", Status: ").append(this.status);
        return sb.toString();
    }
}

