/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.addons.jira.issuepanels;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.EasyList;
import com.atlassian.jira.web.action.issue.ViewIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.opensymphony.user.User;
import com.pmease.quickbuild.addons.jira.QuickBuildManager;
import com.pmease.quickbuild.addons.jira.RestResult;
import com.pmease.quickbuild.addons.jira.issuepanels.FeedbackAction;
import com.pmease.quickbuild.addons.jira.issuepanels.IssueBuildsAction;
import com.pmease.quickbuild.addons.jira.model.BuildSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;

public class IssueBuildsTabPanel
extends AbstractIssueTabPanel {
    private static final Logger logger = Logger.getLogger(IssueBuildsTabPanel.class);
    private final PermissionManager permissionManager;
    private final WebResourceManager webResourceManager;
    private final QuickBuildManager qbManager;

    public IssueBuildsTabPanel(QuickBuildManager qbManager, PermissionManager permissionManager, WebResourceManager webResourceManager) {
        this.qbManager = qbManager;
        this.permissionManager = permissionManager;
        this.webResourceManager = webResourceManager;
    }

    public List getActions(Issue issue, User user) {
        this.webResourceManager.requireResource("com.pmease.quickbuild.addons.jira.jira-quickbuild-plugin:quickbuild-css");
        try {
            List<RestResult<BuildSet>> builds = this.qbManager.getIssueBuilds(issue);
            boolean isDesc = this.isSortDecending();
            for (RestResult<BuildSet> rr : builds) {
                BuildSet buildset = rr.getResult();
                if (buildset == null) continue;
                buildset.sort(!isDesc);
            }
            IssueBuildsAction action = new IssueBuildsAction(this.descriptor, builds, this.qbManager);
            return EasyList.build((Object)((Object)action));
        }
        catch (Exception e) {
            logger.error((Object)"Retrieve builds failed.", (Throwable)e);
            FeedbackAction action = new FeedbackAction("<h3>Retrieve Builds Failed!</h3><p>" + e.getMessage() + "</p>", FeedbackAction.Level.ERROR);
            return EasyList.build((Object)((Object)action));
        }
    }

    protected boolean isSortDecending() {
        try {
            Action viewIssueAction = ActionFactory.getActionFactory().getActionImpl(ViewIssue.class.getName());
            return StringUtils.equalsIgnoreCase((String)((ViewIssue)viewIssueAction).getActionOrder(), (String)"desc");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to figure out how actions are sorted! I'm going to default to descending", (Throwable)e);
            return true;
        }
    }

    public boolean showPanel(Issue issue, User user) {
        if (!this.permissionManager.hasPermission(29, issue, user)) {
            return false;
        }
        String projectKey = issue.getProjectObject().getKey();
        return this.qbManager.isProjectAssociated(projectKey);
    }
}

