/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaPlugin;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageLevel;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import javax.validation.constraints.NotNull;

@Editable(name="Cobertura Setting", category={"Report Settings"}, description="Define the Cobertura report coverage threshold and color.")
public class CoberturaPluginSetting {
    CoverageLevel levelHigh = new CoverageLevel("HIGH", 0.9, "#008C00");
    CoverageLevel levelMedium = new CoverageLevel("MEDIUM", 0.75, "#999966");
    CoverageLevel levelNormal = new CoverageLevel("NORMAL", 0.5, "#FF7400");
    CoverageLevel levelLow = new CoverageLevel("LOW", 0.0, "#FF1A00");

    public static CoberturaPluginSetting get() {
        Configuration c = Context.getConfiguration();
        if (c == null) {
            return null;
        }
        return (CoberturaPluginSetting)PluginSettingHelper.findConfigurationSetting(CoberturaPlugin.class, (Configuration)c, (boolean)true);
    }

    public static String getColor(double coverage) {
        CoberturaPluginSetting setting = CoberturaPluginSetting.get();
        if (setting == null) {
            return ReportUtils.getCoverageColor((Number)coverage);
        }
        if (coverage >= setting.levelHigh.getThreshold()) {
            return setting.levelHigh.getColor();
        }
        if (coverage >= setting.levelMedium.getThreshold()) {
            return setting.levelMedium.getColor();
        }
        if (coverage >= setting.levelNormal.getThreshold()) {
            return setting.levelNormal.getColor();
        }
        return setting.levelLow.getColor();
    }

    @Editable(name="Coverage High", order=100)
    @NotNull
    public CoverageLevel getLevelHigh() {
        return this.levelHigh;
    }

    public void setLevelHigh(CoverageLevel levelHigh) {
        this.levelHigh = levelHigh;
    }

    @Editable(name="Coverage Medium", order=200)
    @NotNull
    public CoverageLevel getLevelMedium() {
        return this.levelMedium;
    }

    public void setLevelMedium(CoverageLevel levelMedium) {
        this.levelMedium = levelMedium;
    }

    @Editable(name="Coverage Normal", order=300)
    @NotNull
    public CoverageLevel getLevelNormal() {
        return this.levelNormal;
    }

    public void setLevelNormal(CoverageLevel levelNormal) {
        this.levelNormal = levelNormal;
    }

    @Editable(name="Coverage Low", order=400)
    @NotNull
    public CoverageLevel getLevelLow() {
        return this.levelLow;
    }

    public void setLevelLow(CoverageLevel levelLow) {
        this.levelLow = levelLow;
    }
}

