/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.parser;

import com.pmease.quickbuild.plugin.report.cobertura.parser.CoberturaUtils;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import java.util.List;
import org.apache.wicket.util.lang.Objects;
import org.dom4j.Element;

public class PackageParser {
    public static void parsePackages(Element root, DataReport packagesReport, DataReport classesReport) {
        List nodes = root.selectNodes("/coverage/packages/package");
        for (Element each : nodes) {
            DataRow row = packagesReport.addRow();
            String packageName = each.valueOf("./@name");
            row.setValue("packageName", (Object)packageName);
            CoberturaUtils.setLineCoverage(row, each);
            CoberturaUtils.setBranchCoverage(row, each);
            CoberturaUtils.setComplexity(row, each);
            int classes = 0;
            int methods = 0;
            int linesDetected = 0;
            int linesTotal = 0;
            int branchesDetected = 0;
            int branchesTotal = 0;
            for (DataRow cRow : classesReport.getRows()) {
                String name = cRow.getValueAsString("packageName");
                if (!Objects.equal((Object)name, (Object)packageName)) continue;
                ++classes;
                methods += cRow.getInt("methods");
                linesDetected += cRow.getInt("linesDetected");
                linesTotal += cRow.getInt("linesTotal");
                branchesDetected += cRow.getInt("branchesDetected");
                branchesTotal += cRow.getInt("branchesTotal");
            }
            row.setValue("classes", (Object)classes);
            row.setValue("methods", (Object)methods);
            row.setValue("linesDetected", (Object)linesDetected);
            row.setValue("linesTotal", (Object)linesTotal);
            row.setValue("branchesDetected", (Object)branchesDetected);
            row.setValue("branchesTotal", (Object)branchesTotal);
        }
    }
}

