/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.parser;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaLine;
import com.pmease.quickbuild.plugin.report.cobertura.parser.CoberturaUtils;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class MethodParser {
    public static void parse(Element root, DataReport methodsReport) {
        List nodes = root.selectNodes("/coverage/packages/package/classes/class/methods/method");
        List sourcePaths = (List)GeneratorContext.getContext().get("cobertura.sourcepaths");
        String workspaceDir = GeneratorContext.getContext().getWorkspaceDir();
        Build build = GeneratorContext.getContext().getCurrentBuild();
        for (Element each : nodes) {
            DataRow row = methodsReport.addRow();
            String className = each.valueOf("../../@name");
            String[] tokens = ReportUtils.splitClassName((String)className);
            row.setValue("packageName", (Object)tokens[0]);
            row.setValue("className", (Object)tokens[1]);
            String methodName = each.attributeValue("name");
            String signature = each.attributeValue("signature");
            row.setValue("methodName", (Object)(methodName + " " + CoberturaUtils.parseSignature(signature)));
            String fileName = each.valueOf("../../@filename");
            fileName = ReportUtils.getRelativePath((List)sourcePaths, (String)fileName, (String)workspaceDir);
            if (Strings.isNullOrEmpty((String)fileName)) {
                fileName = ReportUtils.classNameToFileName((String)className);
            }
            row.setValue("fileName", (Object)fileName);
            List committers = ReportUtils.getCommitters((Build)build, (String)fileName, (boolean)false);
            row.setValue("committers", (Object)committers);
            CoberturaUtils.setLineCoverage(row, each);
            CoberturaUtils.setBranchCoverage(row, each);
            List lineNodes = each.selectNodes("./lines/line");
            int linesTotal = 0;
            int linesDetected = 0;
            int branchesTotal = 0;
            int branchesDetected = 0;
            ArrayList sourceLines = Lists.newArrayListWithCapacity((int)lineNodes.size());
            for (Element lineNode : lineNodes) {
                CoberturaLine line = CoberturaUtils.parseBlock(lineNode);
                sourceLines.add(line);
                ++linesTotal;
                linesDetected += line.getHits() > 0 ? 1 : 0;
                branchesTotal += line.getBranchesTotal();
                branchesDetected += line.getBranchesDetected();
            }
            row.setValue("linesDetected", (Object)linesDetected);
            row.setValue("linesTotal", (Object)linesTotal);
            row.setValue("branchesDetected", (Object)branchesDetected);
            row.setValue("branchesTotal", (Object)branchesTotal);
            row.setValue("sourceLines", (Object)sourceLines);
        }
    }
}

