/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.parser;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaLine;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class CoberturaUtils {
    static void setLinesTotal(DataRow row, Element node) {
        row.setValue("linesTotal", (Object)node.numberValueOf("./@lines-valid"));
    }

    static void setLinesDetected(DataRow row, Element node) {
        row.setValue("linesDetected", (Object)node.numberValueOf("./@lines-covered"));
    }

    static void setBranchesTotal(DataRow row, Element node) {
        row.setValue("branchesTotal", (Object)node.numberValueOf("./@branches-valid"));
    }

    static void setBranchesDetected(DataRow row, Element node) {
        row.setValue("branchesTotal", (Object)node.numberValueOf("./@branches-covered"));
    }

    static void setLineCoverage(DataRow row, Element node) {
        row.setValue("lineCoverage", (Object)node.numberValueOf("./@line-rate"));
    }

    static void setBranchCoverage(DataRow row, Element node) {
        row.setValue("branchCoverage", (Object)node.numberValueOf("./@branch-rate"));
    }

    static void setComplexity(DataRow row, Element node) {
        row.setValue("complexity", (Object)node.numberValueOf("./@complexity"));
    }

    static String getBasicType(char c) {
        switch (c) {
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'L': {
                return "Object";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case '[': {
                return "[]";
            }
        }
        return String.valueOf(c);
    }

    static String getJavaShortType(String type) {
        int pos = type.lastIndexOf("/");
        if (pos > 0) {
            type = type.substring(pos + 1);
        } else if (type.trim().length() == 1) {
            type = CoberturaUtils.getBasicType(type.charAt(0));
        }
        return type;
    }

    static String parseSignature(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return "";
        }
        int pos = str.lastIndexOf(")");
        if (pos < 0) {
            return str;
        }
        String paramstr = str.substring(1, pos);
        String returnType = str.substring(pos + 1);
        Iterator it = Splitter.on((String)";").omitEmptyStrings().trimResults().split((CharSequence)paramstr).iterator();
        ArrayList params = Lists.newArrayList();
        while (it.hasNext()) {
            String p = (String)it.next();
            params.add(CoberturaUtils.getJavaShortType(p));
        }
        return "(" + Joiner.on((String)",").skipNulls().join((Iterable)params) + ") : " + CoberturaUtils.getJavaShortType(returnType);
    }

    static String getAbsolutePath(List<String> sources, String fileName) {
        if (sources.isEmpty()) {
            return null;
        }
        for (String each : sources) {
            File file = new File(each);
            if (!file.exists() || !(file = new File(file, fileName)).exists()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    static String getLineColor(boolean covered) {
        if (covered) {
            return "008C00";
        }
        return "FF1A00";
    }

    static String getLineColor(double coverage) {
        return ReportUtils.getCoverageColor((Number)coverage);
    }

    static CoberturaLine parseBlock(Element node) {
        CoberturaLine block = new CoberturaLine();
        Number number = node.numberValueOf("./@number");
        int lineno = number == null ? 0 : number.intValue();
        block.setStartLine(lineno);
        block.setEndLine(lineno);
        int hits = node.numberValueOf("./@hits").intValue();
        block.setHits(hits);
        String conditionals = node.attributeValue("condition-coverage");
        if (!Strings.isNullOrEmpty((String)conditionals)) {
            String[] conditions = StringUtils.split((String)StringUtils.substringBetween((String)conditionals, (String)"(", (String)")"), (String)"/");
            block.setBranchesDetected(Integer.valueOf(conditions[0]));
            block.setBranchesTotal(Integer.valueOf(conditions[1]));
        }
        return block;
    }
}

