/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.parser;

import com.google.common.base.Strings;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaLine;
import com.pmease.quickbuild.plugin.report.cobertura.parser.CoberturaUtils;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.List;
import org.dom4j.Element;

public class ClassParser {
    public static void parseClasses(Element root, DataReport report) {
        List sourcePaths = (List)GeneratorContext.getContext().get("cobertura.sourcepaths");
        String workspaceDir = GeneratorContext.getContext().getWorkspaceDir();
        Build build = GeneratorContext.getContext().getCurrentBuild();
        List nodes = root.selectNodes("/coverage/packages/package/classes/class");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            String className = each.valueOf("./@name");
            row.setValue("packageName", (Object)ReportUtils.getPackageNameFromClassName((String)className));
            row.setValue("className", (Object)ReportUtils.getClassNameFromClassName((String)className));
            String fileName = each.valueOf("./@filename");
            fileName = ReportUtils.getRelativePath((List)sourcePaths, (String)fileName, (String)workspaceDir);
            if (Strings.isNullOrEmpty((String)fileName)) {
                fileName = ReportUtils.classNameToFileName((String)className);
            }
            row.setValue("fileName", (Object)fileName);
            row.setValue("committers", (Object)ReportUtils.getCommitters((Build)build, (String)fileName, (boolean)false));
            CoberturaUtils.setLineCoverage(row, each);
            CoberturaUtils.setBranchCoverage(row, each);
            CoberturaUtils.setComplexity(row, each);
            int linesDetected = 0;
            int linesTotal = 0;
            int branchesDetected = 0;
            int branchesTotal = 0;
            List lineNodes = each.selectNodes("./methods/method/lines/line");
            for (Element lineNode : lineNodes) {
                CoberturaLine block = CoberturaUtils.parseBlock(lineNode);
                linesDetected += block.getHits() > 0 ? 1 : 0;
                ++linesTotal;
                branchesDetected += block.getBranchesDetected();
                branchesTotal += block.getBranchesTotal();
            }
            Number n = each.numberValueOf("count(./methods/method)");
            row.setValue("methods", (Object)(n == null ? 0 : n.intValue()));
            row.setValue("linesDetected", (Object)linesDetected);
            row.setValue("linesTotal", (Object)linesTotal);
            row.setValue("branchesDetected", (Object)branchesDetected);
            row.setValue("branchesTotal", (Object)branchesTotal);
        }
    }
}

