/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.migration;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import java.io.File;
import java.util.Stack;

public class CoberturaMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport oldSummary = category.createReport("stats");
        File summaryFile = new File(db.getDbDir(), "summary.xml");
        oldSummary.loadFromXML(summaryFile);
        DataReport statsReport = category.createReport("stats");
        DataRow dest = statsReport.addRow();
        int packages = 0;
        int classes = 0;
        int methods = 0;
        int linesDetected = 0;
        int linesTotal = 0;
        int branchesDetected = 0;
        int branchesTotal = 0;
        double cnn = 0.0;
        for (DataRow each : oldSummary.getRows()) {
            packages += each.getInt("packages");
            classes += each.getInt("classes");
            methods += each.getInt("methods");
            linesDetected += each.getInt("linesDetected");
            linesTotal += each.getInt("linesTotal");
            branchesDetected += each.getInt("branchesDetected");
            branchesTotal += each.getInt("branchesTotal");
            cnn += each.getDouble("complexity") * (double)each.getInt("methods");
        }
        dest.setValue("buildId", (Object)context.getBuild().getId());
        dest.setValue("packages", (Object)packages);
        dest.setValue("classes", (Object)classes);
        dest.setValue("methods", (Object)methods);
        dest.setValue("linesDetected", (Object)linesDetected);
        dest.setValue("linesTotal", (Object)linesTotal);
        dest.setValue("branchesDetected", (Object)branchesDetected);
        dest.setValue("branchesTotal", (Object)branchesTotal);
        dest.setValue("lineCoverage", (Object)(linesTotal == 0 ? 0.0 : Double.valueOf(linesDetected) / (double)linesTotal));
        dest.setValue("branchCoverage", (Object)(branchesTotal == 0 ? 0.0 : Double.valueOf(branchesDetected) / (double)branchesTotal));
        dest.setValue("complexity", (Object)(methods == 0 ? 0.0 : cnn / (double)methods));
        category.saveReport(db, statsReport);
    }
}

