/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

@Editable(name="Cobertura Report")
public class CoberturaAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(CoberturaPlugin.class);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        int destMethods = destRow.getInt("methods");
        double sourceCNN = sourceRow.getDouble("methods") * sourceRow.getDouble("complexity");
        double destCNN = (double)destMethods * destRow.getDouble("complexity");
        destMethods = (int)((double)destMethods + sourceRow.getDouble("methods"));
        double complexity = (double)destMethods == 0.0 ? 0.0 : (sourceCNN + destCNN) / (double)destMethods;
        destRow.setValue("methods", (Object)destMethods);
        destRow.setValue("complexity", (Object)complexity);
        int linesTotal = destRow.getInt("linesTotal");
        destRow.setValue("lineCoverage", (Object)MathUtils.divide((int)destRow.getInt("linesDetected"), (int)linesTotal));
        int branchesTotal = destRow.getInt("branchesTotal");
        destRow.setValue("branchCoverage", (Object)MathUtils.divide((int)destRow.getInt("branchesDetected"), (int)branchesTotal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aggregateStats(Build build, File aggregationDir) {
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(aggregationDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "CoberturaAggregator::aggregateStats");
            DataReport report = category.createReport(this.getAggregationStatsReportName());
            DataRow row = report.addRow();
            Date day = DateUtils.truncate((Date)build.getEndDate(), (int)5);
            row.setValue("day", (Object)day);
            DataReport overview = db.loadReport(this.getAggregationOverviewReportName(), new Filter[0]);
            double cnn = 0.0;
            for (DataRow each : overview.getRows()) {
                CoberturaAggregator.sumAndSet("packages", each, row);
                CoberturaAggregator.sumAndSet("classes", each, row);
                CoberturaAggregator.sumAndSet("methods", each, row);
                CoberturaAggregator.sumAndSet("linesDetected", each, row);
                CoberturaAggregator.sumAndSet("linesTotal", each, row);
                CoberturaAggregator.sumAndSet("branchesDetected", each, row);
                CoberturaAggregator.sumAndSet("branchesTotal", each, row);
                cnn += (double)each.getInt("methods") * each.getDouble("complexity");
            }
            row.setValue("lineCoverage", (Object)MathUtils.divide((int)row.getInt("linesDetected"), (int)row.getInt("linesTotal")));
            row.setValue("branchCoverage", (Object)MathUtils.divide((int)row.getInt("branchesDetected"), (int)row.getInt("branchesTotal")));
            row.setValue("complexity", (Object)MathUtils.divide((Number)cnn, (Number)row.getInt("methods")));
            SqlBuilder sql = SqlBuilder.deleteFrom((String)this.getAggregationStatsReportName()).where(new Filter[]{Restrictions.eq((String)"day", (Object)day)});
            db.update(sql);
            category.saveReport(db, report);
        }
        finally {
            db.close();
        }
    }

    static void sumAndSet(String column, DataRow source, DataRow dest) {
        dest.setValue(column, (Object)(source.getInt(column) + dest.getInt(column)));
    }

    protected String[] getAggregateColumns() {
        return new String[]{"packages", "classes", "linesDetected", "linesTotal", "branchesDetected", "branchesTotal", "branchCoverage", "lineCoverage"};
    }
}

