/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Map;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="Cobertura Report", description="<strong>Notice</strong><br/> Make sure this step is running on the same node as the node where you run cobertura task (normally, this will be the node your builder running.)")
@ScriptApi(value="This step publishes the original Cobertura XML files.")
public class CoberturaPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private double lineCoverage;
    @XStreamOmitField
    private double branchCoverage;
    @XStreamOmitField
    private double complexity;
    @XStreamOmitField
    private int linesDetected;
    @XStreamOmitField
    private int linesTotal;
    @XStreamOmitField
    private int branchesDetected;
    @XStreamOmitField
    private int branchesTotal;

    public CoberturaPublisher() {
        this.setStepFailureCondition("false");
        this.setStepFailureMessage("");
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CoberturaPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(GeneratorContext.getContext().getWorkingDir());
        try {
            db.open(DbStore.Mode.READ_WRITE, "CoberturaPublisher::saveStatsReport");
            DataReport packages = db.loadReport("packages", new Filter[0]);
            DataReport summary = category.createReport("stats");
            DataRow row = summary.addRow();
            this.generateStatsReport(packages, row);
            AlwaysNewValue instance = new AlwaysNewValue();
            db.persistRow(row, (MergeFunction)instance);
        }
        finally {
            db.close();
        }
    }

    void generateStatsReport(DataReport packagesReport, DataRow dest) {
        int packages = packagesReport.getRowsCount();
        int classes = 0;
        int methods = 0;
        int linesDetected = 0;
        int linesTotal = 0;
        int branchesDetected = 0;
        int branchesTotal = 0;
        double cnn = 0.0;
        for (DataRow each : packagesReport.getRows()) {
            classes += each.getInt("classes");
            methods += each.getInt("methods");
            linesDetected += each.getInt("linesDetected");
            linesTotal += each.getInt("linesTotal");
            branchesDetected += each.getInt("branchesDetected");
            branchesTotal += each.getInt("branchesTotal");
            cnn += each.getDouble("complexity") * (double)each.getInt("methods");
        }
        dest.setValue("buildId", (Object)GeneratorContext.getContext().getCurrentBuild().getId());
        dest.setValue("packages", (Object)packages);
        dest.setValue("classes", (Object)classes);
        dest.setValue("methods", (Object)methods);
        dest.setValue("linesDetected", (Object)linesDetected);
        dest.setValue("linesTotal", (Object)linesTotal);
        dest.setValue("branchesDetected", (Object)branchesDetected);
        dest.setValue("branchesTotal", (Object)branchesTotal);
        dest.setValue("lineCoverage", (Object)(linesTotal == 0 ? 0.0 : Double.valueOf(linesDetected) / (double)linesTotal));
        dest.setValue("branchCoverage", (Object)(branchesTotal == 0 ? 0.0 : Double.valueOf(branchesDetected) / (double)branchesTotal));
        dest.setValue("complexity", (Object)(methods == 0 ? 0.0 : cnn / (double)methods));
    }

    protected String getStatsReportName() {
        return "stats";
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byPackageUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_package", (String)reportsetName)).build();
    }

    public boolean isStepFailed() {
        DataReport statsReport = this.getStatsReport();
        if (statsReport.isEmpty()) {
            Context.getLogger().debug("No Cobertura stats data found.");
        } else {
            DataRow row = statsReport.getRow(0);
            this.linesTotal = row.getInt("linesTotal");
            this.linesDetected = row.getInt("linesDetected");
            this.lineCoverage = row.getDouble("lineCoverage");
            this.branchesTotal = row.getInt("branchesTotal");
            this.branchesDetected = row.getInt("branchesDetected");
            this.branchCoverage = row.getDouble("branchCoverage");
            this.complexity = row.getDouble("complexity");
        }
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false", "Current complexity is too high", "current.complexity > 5.0"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Average line coverage in Cobertura report.")
    public double getLineCoverage() {
        return this.lineCoverage;
    }

    public void setLineCoverage(double lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    @ScriptApi(value="Average branch coverage in Cobertura report.")
    public double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBlockCoverage(double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    @ScriptApi(value="Average complexity in Cobertura report.")
    public double getComplexity() {
        return this.complexity;
    }

    public void setComplexity(double complexity) {
        this.complexity = complexity;
    }

    @ScriptApi(value="Total lines covered in Cobertura report.")
    public int getLinesDetected() {
        return this.linesDetected;
    }

    public void setLinesDetected(int linesDetected) {
        this.linesDetected = linesDetected;
    }

    @ScriptApi(value="Total lines valid in Cobertura report.")
    public int getLinesTotal() {
        return this.linesTotal;
    }

    public void setLinesTotal(int linesTotal) {
        this.linesTotal = linesTotal;
    }

    @ScriptApi(value="Total branches covered in Cobertura report.")
    public int getBranchesDetected() {
        return this.branchesDetected;
    }

    public void setBranchesDetected(int branchesDetected) {
        this.branchesDetected = branchesDetected;
    }

    @ScriptApi(value="Total branches valid in Cobertura report.")
    public int getBranchesTotal() {
        return this.branchesTotal;
    }

    public void setBranchesTotal(int branchesTotal) {
        this.branchesTotal = branchesTotal;
    }

    public void setBranchCoverage(double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.setValue("stepFailureCondition", "false");
        dom.setValue("stepFailureMessage", "");
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        CoberturaPublisher.removeElement((VersionedDocument)dom, (String)"lineCoverage");
        CoberturaPublisher.removeElement((VersionedDocument)dom, (String)"branchCoverage");
        CoberturaPublisher.removeElement((VersionedDocument)dom, (String)"complexity");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return CoberturaChecksum.class;
    }

    public static class CoberturaChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(CoberturaPlugin.class);
        }
    }
}

