/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.cobertura.parser.CoberturaParser;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class CoberturaProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;
    public static final String SOURCE_PATHS = "cobertura.sourcepaths";

    public CoberturaProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        File inputFile = resource.getFile();
        if (!inputFile.exists()) {
            return;
        }
        Document doc = XMLHelper.readXML((File)inputFile);
        Element root = doc.getRootElement();
        ArrayList sources = Lists.newArrayList();
        List nodes = root.selectNodes("/coverage/sources/source");
        for (Element each : nodes) {
            sources.add(each.getTextTrim());
        }
        this.getContext().put(SOURCE_PATHS, (Object)sources);
        ReportCategory category = this.getCategory();
        DataReport packages = category.createReport("packages");
        DataReport classes = category.createReport("classes");
        DataReport methods = category.createReport("methods");
        CoberturaParser.parse(root, packages, classes, methods);
        File dbDir = this.getContext().getWorkingDir();
        AlwaysNewValue instance = new AlwaysNewValue();
        category.saveReport(dbDir, packages, (MergeFunction)instance);
        category.saveReport(dbDir, classes, (MergeFunction)instance);
        category.saveReport(dbDir, methods, null);
    }
}

