/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.cobertura.CoberturaLine;
import com.pmease.quickbuild.plugin.report.engine.datatype.BlockType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.source.Block;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CoberturaLineType
extends BlockType {
    private static final long serialVersionUID = 1L;

    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        try {
            String[] tokens = new CSVParser(':').parse(str);
            CoberturaLine block = this.getDefaultValue();
            block.setStartLine(Integer.valueOf(tokens[0]));
            block.setEndLine(Integer.valueOf(tokens[1]));
            block.setColor(tokens[2]);
            block.setMessage(tokens[3]);
            if (tokens.length < 5) {
                this.migrate3To4(tokens[3], block);
            } else {
                if (tokens.length >= 5) {
                    block.setHits(Integer.valueOf(tokens[4]));
                }
                if (tokens.length >= 6) {
                    block.setBranchesDetected(Integer.valueOf(tokens[5]));
                }
                if (tokens.length >= 7) {
                    block.setBranchesTotal(Integer.valueOf(tokens[6]));
                }
            }
            return block;
        }
        catch (Exception e) {
            throw new TypeCastException((Object)str, (DataType)this);
        }
    }

    public String asString(Object value, String pattern, Locale locale) {
        Block block = this.typeCast(value);
        if (block == null) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)block);
        }
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)sw, ':');
        try {
            ArrayList<String> str = new ArrayList<String>();
            str.add(String.valueOf(block.getStartLine()));
            str.add(String.valueOf(block.getEndLine()));
            if (block.getColor() == null) {
                str.add("");
            } else {
                str.add(block.getColor());
            }
            if (block.getMessage() == null) {
                str.add("");
            } else {
                str.add(block.getMessage());
            }
            if (block instanceof CoberturaLine) {
                CoberturaLine line = (CoberturaLine)block;
                str.add(String.valueOf(line.getHits()));
                str.add(String.valueOf(line.getBranchesDetected()));
                str.add(String.valueOf(line.branchesTotal));
            }
            writer.join(str);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)sw);
        }
    }

    protected String getWriteFormat() {
        return "XML";
    }

    public CoberturaLine getDefaultValue() {
        return new CoberturaLine();
    }

    private void migrate3To4(String message, CoberturaLine block) {
        String[] conditions;
        if (Strings.isNullOrEmpty((String)message)) {
            return;
        }
        int pos = message.indexOf("(hits)");
        if (pos <= 0) {
            return;
        }
        block.setHits(Integer.valueOf(message.substring(0, pos).trim()));
        message = message.substring(pos + "(hits)".length());
        pos = message.indexOf(40);
        if (pos > 0 && (conditions = StringUtils.split((String)StringUtils.substringBetween((String)(message = message.substring(pos - 1)), (String)"(", (String)")"), (String)"/")).length == 2) {
            block.setBranchesDetected(Integer.valueOf(conditions[0].trim()));
            block.setBranchesTotal(Integer.valueOf(conditions[1].trim()));
        }
    }
}

