/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cobertura;

import com.pmease.quickbuild.plugin.report.cobertura.CoberturaLine;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;

public class CoberturaLineItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public CoberturaLineItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        CoberturaLine line = (CoberturaLine)each;
                        String color = CoberturaLineItem.getBlockColor(line);
                        String message = CoberturaLineItem.formatBlockMessage(line);
                        while (i <= each.getEndLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title='").append(message).append("'>").append(line.getHits()).append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    static double coverage(double detected, double total) {
        return total == 0.0 ? 0.0 : detected / total;
    }

    static String getBlockColor(CoberturaLine line) {
        if (line.isBranch()) {
            return ReportUtils.getCoverageColor((Number)line.getCoverage());
        }
        if (line.getHits() > 0) {
            return "#008C00";
        }
        return "#FF1A00";
    }

    static String formatBlockMessage(CoberturaLine line) {
        if (line.getMessage().contains("conditional")) {
            System.out.println(line.getMessage());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Hits: ").append(line.getHits());
        if (line.isBranch()) {
            sb.append(", conditional coverage [").append(DataTypes.PERCENT.asString((Object)line.getCoverage(), "#%")).append(" (").append(line.getBranchesDetected()).append("/").append(line.getBranchesTotal()).append(")]");
        }
        return sb.toString();
    }
}

