/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.htmlreport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Stack;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="HTML Report", order=300, description="Publish HTML reports to server. This step can run either from server side or from agent side.")
@ScriptApi(value="Publish HTML reports.")
public class HtmlReportPublishStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String reportName;
    private String fromPath;
    private String filePatterns = "**";
    private String startPage = "index.html";
    private int order = 1;

    @Editable(order=900, description="Give a name to this report. It will appear as tab name for this report when displayed in the build info page.")
    @NotEmpty
    @Name
    @ScriptApi(value="Get name of the report.")
    @Scriptable
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Editable(name="Source Directory", order=1000, description="Specify path of the directory where you want to publish html reports from. A non-absolute path is considered to be relative to the workspace directory.")
    @ScriptApi(value="Get the directory from which to publish html reports.")
    @NotEmpty
    @Scriptable
    public String getFromPath() {
        return this.fromPath;
    }

    public void setFromPath(String fromPath) {
        this.fromPath = fromPath;
    }

    @Editable(order=1050, name="Files To Publish", description="Specify patterns of files that need to be published. Patterns will be matched under the <b>source directory</b> specified above.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @ScriptApi(value="Get patterns of files to be published as html reports.")
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    @Editable(order=1100, description="Specify file name of the start page, for example <b>index.html</b>. QuickBuild will display content of this file when user views this report.")
    @ScriptApi(value="Get start page of the HTML reports.")
    @NotEmpty
    @Scriptable
    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        this.startPage = startPage;
    }

    @Editable(order=1200, description="Specify display order of this html report when multiple html reports are published.")
    @Min(value=1L)
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Build build = Context.getBuild();
        File fromDir = FileUtils.resolvePath((File)build.getConfiguration().getWorkspaceDir(), (String)this.getFromPath());
        build.publish(fromDir.getAbsolutePath(), this.getFilePatterns(), "html/" + this.getReportName());
        File tempFile = FileUtils.createTempFile((String)"htmlreport");
        try {
            FileUtils.writeFile((File)tempFile, (String)(this.getStartPage() + "~qb.order=" + this.getOrder()), (String)"UTF-8");
            build.publish(tempFile, "html/" + this.getReportName() + ".startpage");
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("filePatterns").setText("**");
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("order").setText("1");
    }
}

