/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.htmlreport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.extensionpoint.GadgetProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.htmlreport.HtmlReportGadget;
import com.pmease.quickbuild.plugin.htmlreport.HtmlReportPanel;
import com.pmease.quickbuild.plugin.htmlreport.HtmlReportPublishStep;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.markup.html.panel.Panel;

public class HtmlReportPlugin
extends AbstractPlugin {
    public static final String HTMLREPORT_DIR = "html";
    public static final String STARTPAGE_SUFFIX = ".startpage";

    public Object[] getExtensions() {
        return new Object[]{new StepProvider(){

            public Class<? extends Step> getStepClass() {
                return HtmlReportPublishStep.class;
            }
        }, new BuildTabContribution(){
            private static final long serialVersionUID = 1L;

            public int getOrder() {
                return 9999;
            }

            public List<Tab> getTabs() {
                ArrayList<Tab> tabs = new ArrayList<Tab>();
                final File dir = new File(Context.getBuild().getPublishDir(), HtmlReportPlugin.HTMLREPORT_DIR);
                if (dir.exists()) {
                    File[] subdirs = dir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() && new File(dir, file.getName() + HtmlReportPlugin.STARTPAGE_SUFFIX).exists();
                        }
                    });
                    ArrayList<Pair> pairs = new ArrayList<Pair>();
                    for (File subdir : subdirs) {
                        Pair pair = new Pair();
                        pair.setFirst((Object)subdir.getName());
                        File startPage = new File(dir, subdir.getName() + HtmlReportPlugin.STARTPAGE_SUFFIX);
                        String order = StringUtils.substringAfter((String)FileUtils.readFileAsString((File)startPage, (String)"UTF-8"), (String)"~qb.order=");
                        if (StringUtils.isNotBlank((String)order)) {
                            pair.setSecond((Object)Integer.parseInt(order));
                        } else {
                            pair.setSecond((Object)10000);
                        }
                        pairs.add(pair);
                    }
                    Collections.sort(pairs, new Comparator<Pair<String, Integer>>(){

                        @Override
                        public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                            if (((Integer)o1.getSecond()).equals(o2.getSecond())) {
                                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
                            }
                            return (Integer)o1.getSecond() - (Integer)o2.getSecond();
                        }
                    });
                    for (final Pair pair : pairs) {
                        tabs.add(new Tab((String)pair.getFirst()){
                            private static final long serialVersionUID = 1L;

                            public Panel getPanel(String panelId, Map<String, String> panelParams) {
                                return new HtmlReportPanel(panelId, (String)pair.getFirst());
                            }
                        });
                    }
                }
                return tabs;
            }
        }, new GadgetProvider(){

            public Class<? extends Gadget> getGadgetClass() {
                return HtmlReportGadget.class;
            }
        }};
    }

    public Class<?> getSettingClass() {
        return null;
    }

    public PluginCategory getCategory() {
        return PluginCategory.REPORTER;
    }
}

