/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.htmlreport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;

public class HtmlReportPanel
extends Panel {
    private WebMarkupContainer container = new WebMarkupContainer("container");

    public HtmlReportPanel(String id, final String htmlReportName) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        WebMarkupContainer frame = new WebMarkupContainer("frame"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Build build = Context.getBuild();
                File startPage = new File(new File(build.getPublishDir(), "html"), htmlReportName + ".startpage");
                tag.put("src", (CharSequence)build.getDownloadUrl("html" + File.separator + htmlReportName + File.separator + StringUtils.substringBefore((String)FileUtils.readFileAsString((File)startPage, (String)"UTF-8"), (String)"~qb.order="), false));
            }
        };
        this.container.add(new Component[]{frame});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String script = "function adjustFrameHeight() {$('#%s').height($(window).height()-$('#%s').offset().top-56)};adjustFrameHeight();$(window).bind('resize', adjustFrameHeight);";
        response.renderOnLoadJavaScript(String.format(script, this.container.getMarkupId(), this.container.getMarkupId()));
    }
}

