/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.htmlreport;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.BuildBasedGadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetErrorPanel;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.htmlreport.HtmlReportPanel;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.markup.html.panel.Panel;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Published Html Reports", category={"Artifacts and Html Reports"})
public class HtmlReportGadget
extends BuildBasedGadget {
    private String reportName;

    @Editable(description="Select name of the html report.")
    @ChoiceProvider(value="getAvailableReportNames")
    @NotEmpty
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    private static List<String> getAvailableReportNames() {
        File dir;
        ArrayList<String> reportNames = new ArrayList<String>();
        Build build = HtmlReportGadget.guessBuild();
        if (build != null && (dir = new File(build.getPublishDir(), "html")).exists()) {
            File[] reports;
            for (File report : reports = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".startpage");
                }
            })) {
                reportNames.add(StringUtils.substringBeforeLast((String)report.getName(), (String)"."));
            }
        }
        return reportNames;
    }

    protected Panel renderBodyForBuild(String panelId) {
        if (SecurityHelper.hasPermission((Configuration)Context.getConfiguration())) {
            Build build = Context.getBuild();
            File startPage = new File(new File(build.getPublishDir(), "html"), this.getReportName() + ".startpage");
            if (startPage.exists()) {
                return new HtmlReportPanel(panelId, this.getReportName());
            }
            return new GadgetErrorPanel(panelId, "Can not find file '" + startPage.getAbsolutePath() + "'. This may happen if file transferring is interrupted due to network or agent " + "outage while the html report is published.");
        }
        throw new AccessDeniedException("You do not have permission to access configuration '" + Context.getConfiguration() + "'.");
    }
}

