/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.cloud.ec2;

import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.cloud.ec2.EC2NodeLauncher;
import com.pmease.quickbuild.util.StringUtils;
import java.util.Collection;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Launch node into Amazon EC2", order=100)
public class PublicNodeLauncher
extends EC2NodeLauncher {
    private static final long serialVersionUID = 1L;
    private String availabilityZone;
    private String securityGroups;

    @Editable(order=1000, description="Optionally specify availability zone to launch the node into.")
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    @Editable(name="Security Group Names", order=1100, description="Specify security group names to launch new node. Multiple security groups should be separated by comma.<br><b>NOTE:</b> Define security groups carefully to make sure that server and agent can connect to each other (and you may also need to open agent port to other agents if composite steps running on other agents need to run child steps on launched agent).")
    @Scriptable
    @NotEmpty
    public String getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(String securityGroups) {
        this.securityGroups = securityGroups;
    }

    @Override
    protected void complementRunInstancesRequest(RunInstancesRequest runInstancesRequest) {
        runInstancesRequest.setSecurityGroups((Collection)StringUtils.splitAndTrim((String)this.getSecurityGroups()));
        if (this.getAvailabilityZone() != null) {
            Placement placement = new Placement();
            placement.setAvailabilityZone(this.getAvailabilityZone());
            runInstancesRequest.setPlacement(placement);
        }
    }
}

