/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.cloud.ec2;

import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.cloud.ec2.EC2NodeLauncher;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Launch node into Amazon VPC", order=200)
public class PrivateNodeLauncher
extends EC2NodeLauncher {
    private static final long serialVersionUID = 1L;
    private String subnetId;
    private String securityGroups;
    private boolean assignPublicIp;

    @Editable(name="VPC Subnet Id", order=1000, description="Specify subnet id in your VPC to launch node into.")
    @NotEmpty
    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    @Editable(name="Security Group Ids", order=1100, description="Specify security group <b>ids</b> in the VPC to launch new node. Multiple security group Ids should be separated by comma.<br><b>NOTE:</b> Define security group Ids carefully to make sure that server and agent can connect to each other (and you may also need to open agent port to other agents if composite steps running on other agents need to run child steps on launched agent).")
    @Scriptable
    @NotEmpty
    public String getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(String securityGroups) {
        this.securityGroups = securityGroups;
    }

    @Editable(name="Assign Public IP", order=1200, description="Check this to have a public IP assigned on instance creation.")
    public boolean isAssignPublicIp() {
        return this.assignPublicIp;
    }

    public void setAssignPublicIp(boolean assignPublicIp) {
        this.assignPublicIp = assignPublicIp;
    }

    @Override
    protected void complementRunInstancesRequest(RunInstancesRequest runInstancesRequest) {
        if (this.isAssignPublicIp()) {
            InstanceNetworkInterfaceSpecification networkSpecification = new InstanceNetworkInterfaceSpecification();
            networkSpecification.setDeviceIndex(Integer.valueOf(0));
            networkSpecification.setAssociatePublicIpAddress(Boolean.valueOf(true));
            networkSpecification.setSubnetId(this.getSubnetId());
            networkSpecification.setGroups((Collection)StringUtils.splitAndTrim((String)this.getSecurityGroups()));
            ArrayList<InstanceNetworkInterfaceSpecification> networkSpecifications = new ArrayList<InstanceNetworkInterfaceSpecification>();
            networkSpecifications.add(networkSpecification);
            runInstancesRequest.setNetworkInterfaces(networkSpecifications);
        } else {
            runInstancesRequest.setSecurityGroupIds((Collection)StringUtils.splitAndTrim((String)this.getSecurityGroups()));
            runInstancesRequest.setSubnetId(this.getSubnetId());
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element assignPublicIpElement = dom.getRootElement().element("assignPublicIp");
        if (assignPublicIpElement == null) {
            dom.getRootElement().addElement("assignPublicIp").setText("false");
        }
    }
}

