/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.cloud.ec2;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.cloud.ec2.ProxyConfig;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Global setting for EC2 plugin.")
public class EC2Setting {
    private String accessCredentialsFile;
    private ProxyConfig proxyConfig;

    @Editable(name="AWS Access Credentials File", order=100, description="Specify absolute path to a property file containing <a href='http://docs.amazonwebservices.com/AWSSecurityCredentials/1.0/AboutAWSCredentials.html#AccessKeys'>AWS access key id and the secret access key</a>. Content of a sample properties file should look like this:<br><i>accessKey=12345</i><br><i>secretKey=abcdefghijklmn</i>")
    @Scriptable
    @NotEmpty
    public String getAccessCredentialsFile() {
        return this.accessCredentialsFile;
    }

    public void setAccessCredentialsFile(String accessCredentialsFile) {
        this.accessCredentialsFile = accessCredentialsFile;
    }

    @Editable(name="Proxy Configuration", order=200, description="Check this to connect to EC2 via http/https proxy.")
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }
}

