/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.cloud.ec2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStatus;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.grid.cloud.HasToWaitException;
import com.pmease.quickbuild.grid.cloud.NodeLauncher;
import com.pmease.quickbuild.plugin.cloud.ec2.EC2Plugin;
import com.pmease.quickbuild.plugin.cloud.ec2.EC2Setting;
import com.pmease.quickbuild.plugin.cloud.ec2.ProxyConfig;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.util.BackoffCallable;
import com.pmease.quickbuild.util.BackoffException;
import com.pmease.quickbuild.util.EasyList;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.codec.binary.Base64;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EC2NodeLauncher
extends NodeLauncher {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EC2NodeLauncher.class);
    private static final long GIVEUP_TIME = 300000L;
    private static final long BACKOFF_TIME = 10000L;
    private String endPoint;
    private String amiId;
    private String instanceType;
    private String kernalId;
    private String keyName;
    private List<Property> tags;

    @Editable(name="Region", order=100, description="Specify in which region to launch new node.")
    @Expressions(value={"US East (Northern Virginia) Region", "ec2.us-east-1.amazonaws.com", "US West (Oregon) Region", "ec2.us-west-2.amazonaws.com", "US West (Northern California) Region", "ec2.us-west-1.amazonaws.com", "EU (Ireland) Region", "ec2.eu-west-1.amazonaws.com", "Asia Pacific (Singapore) Region", "ec2.ap-southeast-1.amazonaws.com", "Asia Pacific (Tokyo) Region", "ec2.ap-northeast-1.amazonaws.com", "South America (Sao Paulo) Region", "ec2.sa-east-1.amazonaws.com"})
    @NotEmpty
    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Editable(name="AMI ID", order=200, description="Specify ID of the AMI to be used to launch new node.")
    @NotEmpty
    public String getAmiId() {
        return this.amiId;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    @Editable(order=400, description="Specify instance type to launch new node.")
    @ExpressionProvider(value="getAvailableInstanceTypes")
    @NotEmpty
    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    @Editable(name="Kernel Id", order=450, description="Optionally specify the kernel ID to use. If not specified, the default kernel ID will be used.<br><b>NOTE:</b> If launched instance does not pass EC2 status checks, please specify kernel ID explicitly here to match kernel ID of the AMI being used.")
    public String getKernalId() {
        return this.kernalId;
    }

    public void setKernalId(String kernalId) {
        this.kernalId = kernalId;
    }

    @Editable(order=500, description="Optionally specify name of the key pair to be used to login to the newly lauched node. This is only necessary if you want to login to the launched node to diagnose build agent issues.")
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    @Editable(order=600, description="Optionally specify tags applied to instances launched via this profile.")
    public List<Property> getTags() {
        return this.tags;
    }

    public void setTags(List<Property> tags) {
        this.tags = tags;
    }

    private ClientConfiguration getClientConfiguration(EC2Setting ec2Setting) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        ProxyConfig proxyConfig = ec2Setting.getProxyConfig();
        if (proxyConfig != null) {
            clientConfiguration.setProxyHost(proxyConfig.getHost());
            clientConfiguration.setProxyPassword(proxyConfig.getPassword());
            clientConfiguration.setProxyPort(proxyConfig.getPort());
            clientConfiguration.setProxyUsername(proxyConfig.getUser());
        }
        return clientConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String launchNode(String userData) {
        RunInstancesResult runResult;
        PropertiesCredentials credentials;
        EC2Setting setting = (EC2Setting)PluginSettingHelper.getSetting(EC2Plugin.class, (boolean)true);
        try {
            credentials = new PropertiesCredentials(new File(setting.getAccessCredentialsFile()));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)credentials, this.getClientConfiguration(setting));
        ec2.setEndpoint(this.getEndPoint());
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        runInstancesRequest.setInstanceType(this.getInstanceType());
        runInstancesRequest.setImageId(this.getAmiId());
        runInstancesRequest.setMinCount(Integer.valueOf(1));
        runInstancesRequest.setMaxCount(Integer.valueOf(1));
        runInstancesRequest.setUserData(new String(Base64.encodeBase64((byte[])userData.getBytes())));
        this.complementRunInstancesRequest(runInstancesRequest);
        if (this.getKernalId() != null) {
            runInstancesRequest.setKernelId(this.getKernalId());
        }
        if (this.getKeyName() != null) {
            runInstancesRequest.setKeyName(this.getKeyName());
        }
        try {
            runResult = ec2.runInstances(runInstancesRequest);
            if (this.getTags() != null && !this.getTags().isEmpty()) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (Property each : this.getTags()) {
                    tags.add(new Tag(each.getName(), each.getValue()));
                }
                List instances = runResult.getReservation().getInstances();
                for (Instance instance : instances) {
                    CreateTagsRequest createTagsRequest = new CreateTagsRequest();
                    createTagsRequest.withResources(new String[]{instance.getInstanceId()}).withTags(tags);
                    try {
                        new BackoffCallable((Callable)new Callable<Void>((AmazonEC2)ec2, createTagsRequest){
                            final /* synthetic */ AmazonEC2 val$ec2;
                            final /* synthetic */ CreateTagsRequest val$createTagsRequest;
                            {
                                this.val$ec2 = amazonEC2;
                                this.val$createTagsRequest = createTagsRequest;
                            }

                            @Override
                            public Void call() throws Exception {
                                block2: {
                                    try {
                                        this.val$ec2.createTags(this.val$createTagsRequest);
                                    }
                                    catch (AmazonServiceException e) {
                                        if (!e.getErrorCode().contains("InvalidInstanceID.NotFound")) break block2;
                                        throw new BackoffException((Throwable)e);
                                    }
                                }
                                return null;
                            }
                        }, 10000L, 300000L).call();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                    }
                }
            }
        }
        catch (AmazonServiceException e) {
            if (!e.getErrorCode().contains("LimitExceeded") && !e.getErrorCode().contains("InsufficientFreeAddresses")) {
                logger.error("Error launching EC2 node.", (Throwable)e);
                throw e;
            }
            logger.warn("Unable to launch EC2 node.", (Throwable)e);
            throw new HasToWaitException("EC2 limit exceeded: " + e.getErrorCode());
        }
        Preconditions.checkArgument((!runResult.getReservation().getInstances().isEmpty() ? 1 : 0) != 0);
        return ((Instance)runResult.getReservation().getInstances().get(0)).getInstanceId();
    }

    public boolean isTerminated(String nodeInstanceId) {
        PropertiesCredentials credentials;
        EC2Setting setting = (EC2Setting)PluginSettingHelper.getSetting(EC2Plugin.class, (boolean)true);
        try {
            credentials = new PropertiesCredentials(new File(setting.getAccessCredentialsFile()));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)credentials, this.getClientConfiguration(setting));
        ec2.setEndpoint(this.getEndPoint());
        DescribeInstanceStatusRequest describeInstanceRequest = new DescribeInstanceStatusRequest().withInstanceIds(new String[]{nodeInstanceId});
        DescribeInstanceStatusResult describeInstanceResult = ec2.describeInstanceStatus(describeInstanceRequest);
        List state = describeInstanceResult.getInstanceStatuses();
        if (state.isEmpty()) {
            return true;
        }
        return ((InstanceStatus)state.get(0)).getInstanceState().getCode() == 48;
    }

    public void terminateNode(String nodeInstanceId) {
        PropertiesCredentials credentials;
        EC2Setting setting = (EC2Setting)PluginSettingHelper.getSetting(EC2Plugin.class, (boolean)true);
        try {
            credentials = new PropertiesCredentials(new File(setting.getAccessCredentialsFile()));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)credentials, this.getClientConfiguration(setting));
        ec2.setEndpoint(this.getEndPoint());
        TerminateInstancesRequest terminateRequest = new TerminateInstancesRequest(EasyList.create((Object[])new String[]{nodeInstanceId}));
        try {
            new BackoffCallable((Callable)new Callable<Void>((AmazonEC2)ec2, terminateRequest){
                final /* synthetic */ AmazonEC2 val$ec2;
                final /* synthetic */ TerminateInstancesRequest val$terminateRequest;
                {
                    this.val$ec2 = amazonEC2;
                    this.val$terminateRequest = terminateInstancesRequest;
                }

                @Override
                public Void call() throws Exception {
                    block2: {
                        try {
                            this.val$ec2.terminateInstances(this.val$terminateRequest);
                        }
                        catch (AmazonServiceException e) {
                            if (!e.getErrorCode().contains("InvalidInstanceID.NotFound")) break block2;
                            throw new BackoffException((Throwable)e);
                        }
                    }
                    return null;
                }
            }, 10000L, 300000L).call();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private static Map<String, String> getAvailableInstanceTypes() {
        HashMap<String, String> availableInstanceTypes = new HashMap<String, String>();
        for (InstanceType each : EnumSet.allOf(InstanceType.class)) {
            availableInstanceTypes.put(each.toString(), each.toString());
        }
        return availableInstanceTypes;
    }

    protected abstract void complementRunInstancesRequest(RunInstancesRequest var1);
}

