/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.setting;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageLevel;
import com.pmease.quickbuild.plugin.report.ncover.NCoverPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import javax.validation.constraints.NotNull;

@Editable(name="NCover Setting", description="Define the NCover report coverage threshold and color.")
public class NCoverSetting {
    CoverageLevel levelHigh = new CoverageLevel("HIGH", 0.9, "#008C00");
    CoverageLevel levelMedium = new CoverageLevel("MEDIUM", 0.75, "#999966");
    CoverageLevel levelNormal = new CoverageLevel("NORMAL", 0.5, "#FF7400");
    CoverageLevel levelLow = new CoverageLevel("LOW", 0.0, "#FF1A00");

    public static NCoverSetting get() {
        Configuration c = Context.getConfiguration();
        if (c == null) {
            return null;
        }
        return (NCoverSetting)PluginSettingHelper.findConfigurationSetting(NCoverPlugin.class, (Configuration)c, (boolean)true);
    }

    @Editable(name="Coverage High", order=100)
    @NotNull
    public CoverageLevel getLevelHigh() {
        return this.levelHigh;
    }

    public void setLevelHigh(CoverageLevel levelHigh) {
        this.levelHigh = levelHigh;
    }

    @Editable(name="Coverage Medium", order=200)
    @NotNull
    public CoverageLevel getLevelMedium() {
        return this.levelMedium;
    }

    public void setLevelMedium(CoverageLevel levelMedium) {
        this.levelMedium = levelMedium;
    }

    @Editable(name="Coverage Normal", order=300)
    @NotNull
    public CoverageLevel getLevelNormal() {
        return this.levelNormal;
    }

    public void setLevelNormal(CoverageLevel levelNormal) {
        this.levelNormal = levelNormal;
    }

    @Editable(name="Coverage Low", order=400)
    @NotNull
    public CoverageLevel getLevelLow() {
        return this.levelLow;
    }

    public void setLevelLow(CoverageLevel levelLow) {
        this.levelLow = levelLow;
    }
}

