/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.renderer;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CoverageItem;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractNCoverCoverageItem
extends CoverageItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String visited;
    @Alias
    private String unvisited;
    @Alias
    private String average;

    public AbstractNCoverCoverageItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public int getDetectedNumber(ItemContext context) {
        return this.getVisitedNumber(context);
    }

    public int getVisitedNumber(ItemContext context) {
        Map map = context.getExpressionContext();
        return MapUtils.getIntValue((Map)map, (Object)this.getVisited(), (int)0);
    }

    public int getUnvisitedNumber(ItemContext context) {
        Map map = context.getExpressionContext();
        return MapUtils.getIntValue((Map)map, (Object)this.getUnvisited(), (int)0);
    }

    public int getTotalNumber(ItemContext context) {
        int v = this.getVisitedNumber(context);
        int uv = this.getUnvisitedNumber(context);
        return v + uv;
    }

    public String getCoverageColor(double coverage, ItemContext context) {
        Map map = context.getExpressionContext();
        double average = MapUtils.getDoubleValue((Map)map, (Object)this.getAverage(), (double)0.0);
        if (coverage >= average) {
            return "#008C00";
        }
        return "#FF1A00";
    }

    public String getVisited() {
        return this.visited;
    }

    public void setVisited(String visited) {
        this.visited = visited;
    }

    public String getUnvisited() {
        return this.unvisited;
    }

    public void setUnvisited(String unvisited) {
        this.unvisited = unvisited;
    }

    public String getAverage() {
        return this.average;
    }

    public void setAverage(String average) {
        this.average = average;
    }
}

