/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.parser;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class NCover3TrendReportParser {
    public static void parseStats(Element element, DataRow row) {
        row.setValue("acp", (Object)(XMLHelper.getDouble((Node)element, (String)"./@acp", (Double)0.0) / 100.0));
        row.setValue("afp", (Object)(XMLHelper.getDouble((Node)element, (String)"./@afp", (Double)0.0) / 100.0));
        row.setValue("abp", (Object)(XMLHelper.getDouble((Node)element, (String)"./@abp", (Double)0.0) / 100.0));
        row.setValue("acc", (Object)XMLHelper.getInt((Node)element, (String)"./@acc", (Integer)0));
        row.setValue("ccavg", (Object)XMLHelper.getDouble((Node)element, (String)"./@ccavg", (Double)0.0));
        row.setValue("ccmax", (Object)XMLHelper.getInt((Node)element, (String)"./@ccmax", (Integer)0));
        row.setValue("ubp", (Object)XMLHelper.getLong((Node)element, (String)"./@ubp", (Long)0L));
        row.setValue("ul", (Object)XMLHelper.getLong((Node)element, (String)"./@ul", (Long)0L));
        row.setValue("um", (Object)XMLHelper.getLong((Node)element, (String)"./@um", (Long)0L));
        row.setValue("usp", (Object)XMLHelper.getLong((Node)element, (String)"./@usp", (Long)0L));
        row.setValue("vbp", (Object)XMLHelper.getLong((Node)element, (String)"./@vbp", (Long)0L));
        row.setValue("vl", (Object)XMLHelper.getLong((Node)element, (String)"./@vl", (Long)0L));
        row.setValue("vsp", (Object)XMLHelper.getLong((Node)element, (String)"./@vsp", (Long)0L));
        row.setValue("mvc", (Object)XMLHelper.getLong((Node)element, (String)"./@mvc", (Long)0L));
        row.setValue("vm", (Object)XMLHelper.getLong((Node)element, (String)"./@vm", (Long)0L));
        row.setValue("svc", (Object)XMLHelper.getLong((Node)element, (String)"./@svc", (Long)0L));
        row.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(row));
        row.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(row));
        row.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(row));
    }

    public static void generateDocReport(DataReport report, Document doc) {
        String workspacePath = GeneratorContext.getContext().getWorkspaceDir();
        List nodes = doc.selectNodes("//doc");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            String url = XMLHelper.getString((Node)each, (String)"url");
            url = ReportUtils.getRelativePath((String)url, (String)workspacePath);
            row.setValue("fileUrl", (Object)url);
            row.setValue("docId", (Object)XMLHelper.getString((Node)each, (String)"id"));
            row.setValue("committers", (Object)ReportUtils.getCommitters((Build)Context.getBuild(), (String)url, (boolean)true));
            NCover3TrendReportParser.parseStats(each.element("stats"), row);
        }
    }

    public static void generateNamespaceReport(DataReport report, Document doc) {
        List nodes = doc.selectNodes("//ns");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            row.setValue("nsName", (Object)XMLHelper.getString((Node)each, (String)"name", (String)"default"));
            NCover3TrendReportParser.parseStats(each.element("stats"), row);
        }
    }

    public static void generateClassReport(DataReport report, Document doc) {
        List nodes = doc.selectNodes("//class");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            Element statsElement = each.element("stats");
            row.setValue("docId", (Object)XMLHelper.getLong((Node)statsElement, (String)"doc", (Long)0L));
            row.setValue("nsName", (Object)XMLHelper.getString((Node)each, (String)"../name", (String)"default"));
            row.setValue("className", (Object)XMLHelper.getString((Node)each, (String)"./name", (String)"default"));
            NCover3TrendReportParser.parseStats(statsElement, row);
        }
    }

    public static void generateMethodReport(DataReport report, Document doc) {
        List nodes = doc.selectNodes("//method");
        for (Element each : nodes) {
            DataRow row = report.addRow();
            Element statsElement = each.element("stats");
            row.setValue("docId", (Object)XMLHelper.getLong((Node)statsElement, (String)"doc", (Long)0L));
            row.setValue("nsName", (Object)XMLHelper.getString((Node)each, (String)"../../name", (String)"default"));
            row.setValue("className", (Object)XMLHelper.getString((Node)each, (String)"../name", (String)"default"));
            row.setValue("signature", (Object)XMLHelper.getString((Node)each, (String)"./signature", (String)"default"));
            NCover3TrendReportParser.parseStats(statsElement, row);
        }
    }
}

