/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.parser;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class NCover3CoverageReportParser {
    static final long LINE_TYPE = 65536L;
    static final long BRANCH_TYPE = 131072L;

    public static void generateMethodReport(DataReport report, Document doc) {
        List nodes = doc.selectNodes("//method");
        for (Element each : nodes) {
            long methodVc;
            DataRow row = report.addRow();
            String className = each.valueOf("../@signature");
            row.setValue("nsName", (Object)ReportUtils.getPackageNameFromClassName((String)className));
            row.setValue("className", (Object)ReportUtils.getClassNameFromClassName((String)className));
            row.setValue("signature", (Object)each.attributeValue("signature"));
            Element e = (Element)each.selectSingleNode("..//seqpnt[@doc>0][1]");
            if (e != null) {
                row.setValue("docId", (Object)Long.valueOf(e.attributeValue("doc")));
            }
            long um = (methodVc = Long.valueOf(each.attributeValue("vc")).longValue()) > 0L ? 0L : 1L;
            long vm = methodVc > 0L ? 1L : 0L;
            int cc = Integer.valueOf(each.attributeValue("cc"));
            row.setValue("ccmax", (Object)cc);
            row.setValue("ccavg", (Object)cc);
            List seqpnts = each.elements("seqpnt");
            row.setValue("um", (Object)um);
            row.setValue("vm", (Object)vm);
            NCover3CoverageReportParser.calcData(row, seqpnts);
            row.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(row));
            row.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(row));
            row.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(row));
        }
    }

    private static void calcData(DataRow row, List<Element> seqpnts) {
        long vsp = 0L;
        long usp = 0L;
        long vbp = 0L;
        long ubp = 0L;
        long vl = 0L;
        long ul = 0L;
        for (Element seq : seqpnts) {
            long fl = Long.valueOf(seq.attributeValue("fl"));
            int vc = Integer.valueOf(seq.attributeValue("vc"));
            if (fl == 65536L) {
                if (vc > 0) {
                    ++vsp;
                } else {
                    ++usp;
                }
            } else if (fl == 131072L) {
                if (vc > 0) {
                    ++vbp;
                } else {
                    ++ubp;
                }
            }
            int startline = Integer.valueOf(seq.attributeValue("l"));
            int endline = Integer.valueOf(seq.attributeValue("el"));
            if (vc > 0) {
                vl += (long)(endline - startline + 1);
                continue;
            }
            ul += (long)(endline - startline + 1);
        }
        row.setValue("vbp", (Object)vbp);
        row.setValue("ubp", (Object)ubp);
        row.setValue("vsp", (Object)vsp);
        row.setValue("usp", (Object)usp);
        row.setValue("vl", (Object)vl);
        row.setValue("ul", (Object)ul);
    }

    public static void generateDocReport(DataReport report, Document doc) {
        List nodes = doc.selectNodes("//doc");
        String workspaceDir = GeneratorContext.getContext().getWorkspaceDir();
        for (Element each : nodes) {
            DataRow row = report.addRow();
            Long docId = Long.valueOf(each.attributeValue("id"));
            row.setValue("docId", (Object)docId);
            row.setValue("fileUrl", (Object)ReportUtils.getRelativePath((String)each.attributeValue("url"), (String)workspaceDir));
            List seqpnts = doc.selectNodes("//seqpnt[@doc=" + docId + "]");
            NCover3CoverageReportParser.calcData(row, seqpnts);
            row.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(row));
            row.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(row));
            row.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(row));
        }
    }

    public void generateClassReport(DataReport methods, DataReport classes) {
        String key;
        String className;
        String nsName;
        Long docId;
        HashMap map = Maps.newHashMap();
        HashMap cclist = Maps.newHashMap();
        for (DataRow src : methods.getRows()) {
            CCAvg a;
            DataRow dest;
            docId = src.getLong("docId");
            nsName = src.getValueAsString("nsName");
            className = src.getValueAsString("className");
            key = nsName + "." + className + "." + docId;
            if (map.containsKey(key)) {
                dest = classes.getRow(((Integer)map.get(key)).intValue());
            } else {
                map.put(key, classes.getRowsCount());
                dest = classes.addRow();
                dest.setValue("docId", (Object)docId);
                dest.setValue("nsName", (Object)nsName);
                dest.setValue("className", (Object)className);
            }
            dest.setValue("vsp", (Object)(dest.getLong("vsp") + src.getLong("vsp")));
            dest.setValue("usp", (Object)(dest.getLong("usp") + src.getLong("usp")));
            dest.setValue("vbp", (Object)(dest.getLong("vbp") + src.getLong("vbp")));
            dest.setValue("ubp", (Object)(dest.getLong("ubp") + src.getLong("ubp")));
            dest.setValue("vm", (Object)(dest.getLong("vm") + src.getLong("vm")));
            dest.setValue("um", (Object)(dest.getLong("um") + src.getLong("um")));
            dest.setValue("vl", (Object)(dest.getLong("vl") + src.getLong("vl")));
            dest.setValue("ul", (Object)(dest.getLong("ul") + src.getLong("ul")));
            int cc = src.getInt("ccmax");
            dest.setValue("ccmax", (Object)Math.max(dest.getInt("ccmax"), cc));
            if (cclist.containsKey(key)) {
                a = (CCAvg)cclist.get(key);
                a.cctotal += cc;
                ++a.num;
                cclist.put(key, a);
                continue;
            }
            a = new CCAvg();
            a.cctotal += cc;
            ++a.num;
            cclist.put(key, a);
        }
        for (DataRow dest : classes.getRows()) {
            docId = dest.getLong("docId");
            nsName = dest.getValueAsString("nsName");
            className = dest.getValueAsString("className");
            key = nsName + "." + className + "." + docId;
            dest.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(dest));
            dest.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(dest));
            dest.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(dest));
            CCAvg a = (CCAvg)cclist.get(key);
            dest.setValue("ccavg", (Object)a.getAvg());
        }
    }

    public void generateNamespaceReport(DataReport classes, DataReport namespaces) {
    }

    private class CCAvg {
        int cctotal = 0;
        int num = 0;

        private CCAvg() {
        }

        double getAvg() {
            return MathUtils.divide((int)this.cctotal, (int)this.num);
        }
    }
}

