/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.migration;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.util.Map;
import java.util.Stack;

public class NCoverMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        ReportCategory category = db.getCategory();
        DataReport statsReport = category.createReport("stats");
        DataRow row = statsReport.addRow();
        SqlBuilder query = SqlBuilder.query().select(NCoverHelper.getStatsQuery().getSelectColumns()).from(new String[]{"buildstats"});
        Map stats = db.queryForMap(query);
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getBuild().getId());
        double symbolCoverage = NCoverHelper.getSymbolCoverage(row);
        double branchCoverage = NCoverHelper.getBranchCoverage(row);
        double methodCoverage = NCoverHelper.getMethodCoverage(row);
        row.setValue("symbolCoverage", (Object)symbolCoverage);
        row.setValue("branchCoverage", (Object)branchCoverage);
        row.setValue("methodCoverage", (Object)methodCoverage);
        category.saveReport(db, statsReport);
    }
}

