/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.generator;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.generator.group.GroupProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.io.File;
import java.util.Map;

public class StatsReportProcessor
extends GroupProcessor {
    private static final long serialVersionUID = 1L;

    public StatsReportProcessor(ReportCategory category) {
        super(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        File dbDir = this.getContext().getWorkingDir();
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(dbDir);
        DataReport report = this.getContext().getDestReport();
        Preconditions.checkState((boolean)report.isEmpty());
        DataRow row = report.addRow();
        try {
            db.open(DbStore.Mode.READ_ONLY, "StatsReportProcessor::doExecute");
            int methods = db.queryForInt("SELECT COUNT(*) FROM methods");
            int classes = db.queryForInt("SELECT COUNT(*) FROM classes");
            int namespaces = db.queryForInt("SELECT COUNT(*) FROM namespaces");
            row.setValue("buildId", (Object)Context.getBuild().getId());
            row.setValue("namespaces", (Object)namespaces);
            row.setValue("classes", (Object)classes);
            row.setValue("methods", (Object)methods);
            SqlBuilder query = SqlBuilder.query().select(NCoverHelper.GROUP_COLUMNS).from(new String[]{"namespaces"});
            Map map = db.queryForMap(query);
            for (Map.Entry entry : map.entrySet()) {
                row.setValue((String)entry.getKey(), entry.getValue());
            }
        }
        finally {
            db.close();
        }
    }
}

