/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.generator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.group.GroupProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NCoverGroupProcessor
extends GroupProcessor {
    private static final long serialVersionUID = 1L;

    public NCoverGroupProcessor(ReportCategory category) {
        super(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(GeneratorResource resource) {
        File dbDir = this.getContext().getWorkingDir();
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(dbDir);
        ReportDataSource ds = resource.getReportResource();
        DataReport dest = this.getContext().getDestReport();
        List list = Lists.newArrayList();
        try {
            db.open(DbStore.Mode.READ_WRITE, "NCoverGroupProcessor::processResource");
            SqlBuilder query = SqlBuilder.query().select(this.getSelects(dest)).from(new String[]{ds.getFrom()}).groupby(dest.getMeta().getPrimaryKeys());
            list = db.queryForMapList(query);
        }
        finally {
            db.close();
        }
        for (Map map : list) {
            DataRow row = dest.addRow();
            for (Map.Entry each : map.entrySet()) {
                row.setValue((String)each.getKey(), each.getValue());
            }
            row.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(row));
            row.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(row));
            row.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(row));
        }
    }

    String[] getSelects(DataReport dest) {
        ArrayList list = Lists.newArrayList();
        list.addAll(Lists.newArrayList((Object[])dest.getMeta().getPrimaryKeys()));
        list.addAll(Arrays.asList(NCoverHelper.GROUP_COLUMNS));
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }
}

