/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.generator;

import com.google.common.base.Objects;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.ncover.parser.NCover3CoverageReportParser;
import com.pmease.quickbuild.plugin.report.ncover.parser.NCover3TrendReportParser;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.Element;

public class MethodReportProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;
    static final String TREND_COVERAGE_DATA = "trendcoveragedata";
    static final String COVERAGE_DATA = "coverage";
    static final String USE_TREND_COVERAGE = "ncover.parser.usetrendcoverage";

    public MethodReportProcessor(ReportCategory category) {
        super(category);
    }

    protected void processResource(GeneratorResource resource) {
        File xml = resource.getFile();
        Document doc = XMLHelper.readXML((File)xml);
        Element root = doc.getRootElement();
        GeneratorContext context = this.getContext();
        DataReport report = context.getDestReport();
        if (Objects.equal((Object)root.getName(), (Object)TREND_COVERAGE_DATA)) {
            NCover3TrendReportParser.generateMethodReport(report, doc);
        } else if (Objects.equal((Object)root.getName(), (Object)COVERAGE_DATA)) {
            NCover3CoverageReportParser.generateMethodReport(report, doc);
        } else {
            throw new QuickbuildException("Unsupported NCover coverage data file");
        }
    }
}

