/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.generator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.generator.DefaultGenerator;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocReportGenerator
extends DefaultGenerator {
    private static final long serialVersionUID = 1L;

    public DocReportGenerator(ReportCategory category) {
        super(category);
    }

    protected void doExecute() {
        super.doExecute();
        this.groupFromClassReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void groupFromClassReport() {
        File dbDir = this.getContext().getWorkingDir();
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(dbDir);
        DataReport dest = this.getContext().getDestReport();
        List list = Lists.newArrayList();
        try {
            db.open(DbStore.Mode.READ_WRITE, "DocReportGenerator::groupFromClassReport");
            SqlBuilder query = SqlBuilder.query().select(this.getSelects()).from(new String[]{"classes"}).groupby(new String[]{"docId"});
            list = db.queryForMapList(query);
        }
        finally {
            db.close();
        }
        HashMap indexes = Maps.newHashMap();
        for (int i = 0; i < dest.getRowsCount(); ++i) {
            DataRow row = dest.getRow(i);
            indexes.put(row.getLong("docId"), i);
        }
        for (Map map : list) {
            Long docId = (Long)map.get("docId");
            if (!indexes.containsKey(docId)) continue;
            DataRow row = dest.getRow(((Integer)indexes.get(docId)).intValue());
            for (Map.Entry each : map.entrySet()) {
                row.setValue((String)each.getKey(), each.getValue());
            }
            row.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(row));
            row.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(row));
            row.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(row));
        }
    }

    String[] getSelects() {
        ArrayList list = Lists.newArrayList();
        list.add("docId");
        list.addAll(Arrays.asList(NCoverHelper.GROUP_COLUMNS));
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }
}

