/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import com.pmease.quickbuild.plugin.report.ncover.NCoverPlugin;
import java.io.File;
import java.util.List;
import java.util.Map;

@Editable(name="NCover Report")
public class NCoverAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(NCoverPlugin.class);
    }

    static void bigger(String column, DataRow source, DataRow dest) {
        double s = source.getDouble(column);
        double d = dest.getDouble(column);
        dest.setValue(column, (Object)Math.max(s, d));
    }

    static void sum(String column, DataRow source, DataRow dest) {
        double s = source.getDouble(column);
        double d = dest.getDouble(column);
        dest.setValue(column, (Object)(s + d));
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        NCoverAggregator.bigger("acp", sourceRow, destRow);
        NCoverAggregator.bigger("afp", sourceRow, destRow);
        NCoverAggregator.bigger("abp", sourceRow, destRow);
        NCoverAggregator.bigger("acc", sourceRow, destRow);
        NCoverAggregator.sum("ccavg", sourceRow, destRow);
        NCoverAggregator.bigger("ccmax", sourceRow, destRow);
        NCoverAggregator.bigger("mvc", sourceRow, destRow);
        NCoverAggregator.sum("ubp", sourceRow, destRow);
        NCoverAggregator.sum("ul", sourceRow, destRow);
        NCoverAggregator.sum("um", sourceRow, destRow);
        NCoverAggregator.sum("usp", sourceRow, destRow);
        NCoverAggregator.sum("vbp", sourceRow, destRow);
        NCoverAggregator.sum("vl", sourceRow, destRow);
        NCoverAggregator.sum("vsp", sourceRow, destRow);
        NCoverAggregator.sum("vm", sourceRow, destRow);
        NCoverAggregator.sum("svc", sourceRow, destRow);
        NCoverAggregator.sum("namespaces", sourceRow, destRow);
        NCoverAggregator.sum("classes", sourceRow, destRow);
        NCoverAggregator.sum("methods", sourceRow, destRow);
        destRow.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(destRow));
        destRow.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(destRow));
        destRow.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(destRow));
    }

    protected void updateOverviewRow(Build build, List<String> reportsets, DataRow destRow) {
        super.updateOverviewRow(build, reportsets, destRow);
        double ccavg = destRow.getDouble("ccavg");
        destRow.setValue("ccavg", (Object)(ccavg / (double)reportsets.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getOverviewStats(Build build, File aggregationDir) {
        ReportCategory category = this.getCategory();
        CategoryDb db = category.getCategoryDb(aggregationDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "NCoverAggregator::getOverviewStats");
            SqlBuilder query = SqlBuilder.query();
            query.select(NCoverHelper.getStatsQuery().getSelectColumns()).from(new String[]{"agg_overview"});
            query.where(new Filter[]{Restrictions.le((String)"day", (Object)build.getEndDate())});
            Map map = db.queryForMap(query);
            return map;
        }
        finally {
            db.close();
        }
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        destRow.setValue("symbolCoverage", (Object)NCoverHelper.getSymbolCoverage(destRow));
        destRow.setValue("branchCoverage", (Object)NCoverHelper.getBranchCoverage(destRow));
        destRow.setValue("methodCoverage", (Object)NCoverHelper.getMethodCoverage(destRow));
    }
}

