/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class NCoverStatsRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;

    public NCoverStatsRule(ReportCategory category) {
        super(category);
    }

    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        Element rowElement = context.getCurrentElement();
        Element element = (Element)rowElement.selectSingleNode("./stats");
        destRow.setValue("acp", (Object)(XMLHelper.getDouble((Node)element, (String)"acp", (Double)0.0) / 100.0));
        destRow.setValue("afp", (Object)(XMLHelper.getDouble((Node)element, (String)"afp", (Double)0.0) / 100.0));
        destRow.setValue("abp", (Object)(XMLHelper.getDouble((Node)element, (String)"abp", (Double)0.0) / 100.0));
        destRow.setValue("acc", (Object)XMLHelper.getInt((Node)element, (String)"acc", (Integer)0));
        destRow.setValue("ccavg", (Object)XMLHelper.getDouble((Node)element, (String)"ccavg", (Double)0.0));
        destRow.setValue("ccmax", (Object)XMLHelper.getInt((Node)element, (String)"ccmax", (Integer)0));
        destRow.setValue("ubp", (Object)XMLHelper.getLong((Node)element, (String)"ubp", (Long)0L));
        destRow.setValue("ul", (Object)XMLHelper.getLong((Node)element, (String)"ul", (Long)0L));
        destRow.setValue("um", (Object)XMLHelper.getLong((Node)element, (String)"um", (Long)0L));
        destRow.setValue("usp", (Object)XMLHelper.getLong((Node)element, (String)"usp", (Long)0L));
        destRow.setValue("vbp", (Object)XMLHelper.getLong((Node)element, (String)"vbp", (Long)0L));
        destRow.setValue("vl", (Object)XMLHelper.getLong((Node)element, (String)"vl", (Long)0L));
        destRow.setValue("vsp", (Object)XMLHelper.getLong((Node)element, (String)"vsp", (Long)0L));
        destRow.setValue("mvc", (Object)XMLHelper.getLong((Node)element, (String)"mvc", (Long)0L));
        destRow.setValue("vm", (Object)XMLHelper.getLong((Node)element, (String)"vm", (Long)0L));
        destRow.setValue("svc", (Object)XMLHelper.getLong((Node)element, (String)"svc", (Long)0L));
        destRow.setValue("symbolCoverage", (Object)NCoverHelper.getCoverage(destRow, "vsp", "usp"));
        destRow.setValue("branchCoverage", (Object)NCoverHelper.getCoverage(destRow, "vbp", "ubp"));
        destRow.setValue("methodCoverage", (Object)NCoverHelper.getCoverage(destRow, "vm", "um"));
    }

    public String getType() {
        return NCoverStatsRule.class.getName();
    }
}

