/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover;

import com.google.common.collect.ImmutableMap;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.ncover.NCoverHelper;
import com.pmease.quickbuild.plugin.report.ncover.NCoverPlugin;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="NCover Report", description="Publish NCover reports")
@ScriptApi(value="This step publishes the original NCover XML files.")
public class NCoverPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int namespaces;
    @XStreamOmitField
    private int classes;
    @XStreamOmitField
    private int methods;
    @XStreamOmitField
    private double symbolCoverage;
    @XStreamOmitField
    private double branchCoverage;
    @XStreamOmitField
    private double methodCoverage;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(NCoverPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        File dbDir = context.getWorkingDir();
        if (!dbDir.exists()) {
            return;
        }
        DataReport statsReport = category.createReport("stats");
        Map stats = category.getDefaultStats(dbDir, "buildstats", new Filter[0]);
        DataRow row = statsReport.addRow();
        row.fromMap(stats);
        row.setValue("buildId", (Object)context.getCurrentBuild().getId());
        long totals = MapUtils.getLongValue((Map)stats, (Object)"TOTALS", (long)0L);
        double ccavg = MapUtils.getDoubleValue((Map)stats, (Object)"ccavg", (double)0.0);
        row.setValue("ccavg", (Object)(totals == 0L ? 0.0 : ccavg / (double)totals));
        this.symbolCoverage = NCoverHelper.getSymbolCoverage(row);
        this.branchCoverage = NCoverHelper.getBranchCoverage(row);
        this.methodCoverage = NCoverHelper.getMethodCoverage(row);
        this.namespaces = row.getInt("namespaces");
        this.classes = row.getInt("classes");
        this.methods = row.getInt("methods");
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "NCoverPublisher::saveStatsReport");
            Integer ccmax = db.queryForInt("select MAX(ccmax) from buildstats");
            row.setValue("ccmax", (Object)ccmax);
        }
        finally {
            db.close();
        }
        row.setValue("symbolCoverage", (Object)this.symbolCoverage);
        row.setValue("branchCoverage", (Object)this.branchCoverage);
        row.setValue("methodCoverage", (Object)this.methodCoverage);
        category.saveReport(dbDir, statsReport);
    }

    protected String getStatsReportName() {
        return "stats";
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return ImmutableMap.builder().put((Object)"byNamespaceUrl", (Object)ReportUtils.getReportsetUrl((Build)this.getBuild(), (String)Tab.title2id((String)this.getCategory().getName()), (String)"by_namespace", (String)reportsetName)).build();
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    @ScriptApi(value="Total namespaces in NCover report.")
    public int getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(int namespaces) {
        this.namespaces = namespaces;
    }

    @ScriptApi(value="Total classes in NCover report.")
    public int getClasses() {
        return this.classes;
    }

    public void setClasses(int classes) {
        this.classes = classes;
    }

    @ScriptApi(value="Total methods in NCover report.")
    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    @ScriptApi(value="The symbol coverage in NCover report.")
    public double getSymbolCoverage() {
        return this.symbolCoverage;
    }

    public void setSymbolCoverage(double symbolCoverage) {
        this.symbolCoverage = symbolCoverage;
    }

    @ScriptApi(value="The branch coverage in NCover report.")
    public double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBranchCoverage(double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    @ScriptApi(value="The method coverage in NCover report.")
    public double getMethodCoverage() {
        return this.methodCoverage;
    }

    public void setMethodCoverage(double methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"namespaces");
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"classes");
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"methods");
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"symbolCoverage");
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"branchCoverage");
        NCoverPublisher.removeElement((VersionedDocument)dom, (String)"methodCoverage");
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return NCoverChecksum.class;
    }

    public static class NCoverChecksum
    extends BuildReportPublisher.ChecksumJob {
        protected ReportCategory getCategory() {
            return ReportHelper.getCategory(NCoverPlugin.class);
        }
    }
}

