/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.ncover;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.StatsQuery;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import java.util.Arrays;

public class NCoverHelper {
    public static String[] GROUP_COLUMNS = new String[]{"AVG(acp) AS acp", "AVG(afp) AS afp", "AVG(abp) AS abp", "AVG(acc) AS acc", "AVG(ccavg) AS ccavg", "MAX(ccmax) AS ccmax", "MAX(mvc) AS mvc", "SUM(ubp) AS ubp", "SUM(ul) AS ul", "SUM(um) AS um", "SUM(usp) AS usp", "SUM(vbp) AS vbp", "SUM(vl) AS vl", "SUM(vsp) AS vsp", "SUM(vm) AS vm", "SUM(svc) AS svc"};

    public static double getCoverage(DataRow row, String visited, String unvisited) {
        Long v = row.getLong(visited);
        Long u = row.getLong(unvisited);
        Long total = v + u;
        return MathUtils.divide((Number)v, (Number)total);
    }

    public static double getSymbolCoverage(DataRow row) {
        return NCoverHelper.getCoverage(row, "vsp", "usp");
    }

    public static double getBranchCoverage(DataRow row) {
        return NCoverHelper.getCoverage(row, "vbp", "ubp");
    }

    public static double getMethodCoverage(DataRow row) {
        return NCoverHelper.getCoverage(row, "vm", "um");
    }

    public static double getLineCoverage(DataRow row) {
        return NCoverHelper.getCoverage(row, "vl", "ul");
    }

    public static StatsQuery getStatsQuery() {
        StatsQuery query = new StatsQuery();
        query.setSelectColumns((String[])Iterables.toArray((Iterable)ImmutableList.builder().add((Object)"COUNT(*) AS TOTALS").addAll(Arrays.asList(GROUP_COLUMNS)).build(), String.class));
        return query;
    }
}

