/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cppcheck.renderer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.cppcheck.CppCheckPlugin;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.util.LinkedHashMap;
import java.util.List;

public class CppCheckSourceItem
extends ViewSourceLinkItem {
    public CppCheckSourceItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected Block[] rowsToBlocks(List<DataRow> rows) {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        for (DataRow each : rows) {
            CppCheckLine block;
            int line = each.getInt("line");
            if (line == 0) {
                line = 1;
            }
            if ((block = (CppCheckLine)((Object)blocks.get(line))) == null) {
                block = new CppCheckLine();
            }
            block.setStartLine(line);
            block.setEndLine(line);
            block.setMessage(each.getString("verboseMessage"));
            block.setColor(CppCheckPlugin.getColorBySeverity(each.getString("severity")));
            block.setSeverity(each.getString("severity"));
            blocks.put(line, block);
        }
        return (Block[])Iterables.toArray(blocks.values(), Block.class);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        CppCheckLine line = (CppCheckLine)each;
                        while (i < each.getStartLine() && i <= lines.length) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        String color = each.getColor();
                        String message = each.getMessage();
                        message = 1.escapeMessage((String)message);
                        while (i <= each.getEndLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title=\"").append(message).append("\">").append(line.getSeverity()).append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: " + color + "'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    static class CppCheckLine
    extends Block {
        String severity;

        CppCheckLine() {
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }
    }
}

