/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.cppcheck;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.report.cppcheck.CppCheckPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(category={"Publish"}, name="CppCheck Report", description="Publish CppCheck XML reports")
@ScriptApi(value="This step publishes the original CppCheck XML files.")
public class CppCheckPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int totalBugs;
    @XStreamOmitField
    private int errors;
    @XStreamOmitField
    private int warnings;
    @XStreamOmitField
    private int styles;
    @XStreamOmitField
    private int performances;
    @XStreamOmitField
    private int portabilities;
    @XStreamOmitField
    private int informations;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CppCheckPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "CppCheckPublisher::saveStatsReport");
            Map map = category.getDefaultStats(db, "files", new Filter[0]);
            this.totalBugs = MapUtils.getIntValue((Map)map, (Object)"totalBugs");
            this.errors = MapUtils.getIntValue((Map)map, (Object)"errors");
            this.warnings = MapUtils.getIntValue((Map)map, (Object)"warnings");
            this.informations = MapUtils.getIntValue((Map)map, (Object)"informations");
            this.performances = MapUtils.getIntValue((Map)map, (Object)"performances");
            this.portabilities = MapUtils.getIntValue((Map)map, (Object)"portabilities");
            this.styles = MapUtils.getIntValue((Map)map, (Object)"styles");
            DataRow row = statsReport.addRow();
            row.setValue("buildId", (Object)Context.getBuild().getId());
            row.setValue("totalBugs", (Object)this.totalBugs);
            row.setValue("errors", (Object)this.errors);
            row.setValue("warnings", (Object)this.warnings);
            row.setValue("informations", (Object)this.informations);
            row.setValue("performances", (Object)this.performances);
            row.setValue("portabilities", (Object)this.portabilities);
            row.setValue("styles", (Object)this.styles);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    public boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.You can use below numbers in your failure condition: <br/>current.totalBugs, current.errors, current.warnings, current.styles, current.performances, current.portabilities, current.informations ")
    @Expressions(value={"has bug", "current.totalBugs > 0", "I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return super.getStepFailureCondition();
    }

    protected String getStatsReportName() {
        return "stats";
    }

    @ScriptApi(value="Get total bugs")
    public int getTotalBugs() {
        return this.totalBugs;
    }

    public void setTotalBugs(int totalBugs) {
        this.totalBugs = totalBugs;
    }

    @ScriptApi(value="Get bug number of severity error")
    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    @ScriptApi(value="Get bug number of severity warning")
    public int getWarnings() {
        return this.warnings;
    }

    public void setWarnings(int warnings) {
        this.warnings = warnings;
    }

    @ScriptApi(value="Get bug number of severity style")
    public int getStyles() {
        return this.styles;
    }

    public void setStyles(int styles) {
        this.styles = styles;
    }

    @ScriptApi(value="Get bug number of severity performance")
    public int getPerformances() {
        return this.performances;
    }

    public void setPerformances(int performances) {
        this.performances = performances;
    }

    @ScriptApi(value="Get bug number of severity portabilities")
    public int getPortabilities() {
        return this.portabilities;
    }

    public void setPortabilities(int portabilities) {
        this.portabilities = portabilities;
    }

    public int getInformations() {
        return this.informations;
    }

    public void setInformations(int informations) {
        this.informations = informations;
    }
}

